/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.foldericon;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.foldericon.Messages;
import org.apache.commons.fileupload2.core.FileItem;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class CustomFolderIcon
extends FolderIcon {
    private static final Logger LOGGER = Logger.getLogger(CustomFolderIcon.class.getName());
    private static final String DEFAULT_ICON_PATH = "plugin/custom-folder-icon/icons/default.svg";
    private final String foldericon;
    private AbstractFolder<?> owner;

    @DataBoundConstructor
    public CustomFolderIcon(String foldericon) {
        this.foldericon = foldericon;
    }

    @NonNull
    public static Set<String> getAvailableIcons() {
        try {
            FilePath iconDir = Jenkins.get().getRootPath().child("userContent").child("customFolderIcons");
            if (iconDir.exists()) {
                return iconDir.list().stream().sorted(Comparator.comparingLong(file -> {
                    try {
                        return file.lastModified();
                    }
                    catch (IOException | InterruptedException ex) {
                        return 0L;
                    }
                }).reversed()).map(FilePath::getName).collect(Collectors.toSet());
            }
            return Set.of();
        }
        catch (IOException | InterruptedException ex) {
            LOGGER.log(Level.WARNING, ex, () -> "Unable to list available icons!");
            return Set.of();
        }
    }

    protected void setOwner(AbstractFolder<?> folder) {
        this.owner = folder;
    }

    public String getFoldericon() {
        return this.foldericon;
    }

    public String getImageOf(String size) {
        if (this.getFoldericon() != null && !this.getFoldericon().isBlank()) {
            return Stapler.getCurrentRequest2().getContextPath() + Jenkins.RESOURCE_PATH + "/userContent/customFolderIcons/" + this.getFoldericon();
        }
        return Stapler.getCurrentRequest2().getContextPath() + Jenkins.RESOURCE_PATH + "/plugin/custom-folder-icon/icons/default.svg";
    }

    public String getDescription() {
        if (this.owner != null) {
            return this.owner.getPronoun();
        }
        return Messages.Folder_description();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends FolderIconDescriptor {
        private static final int CHMOD = 420;
        private static final long FILE_SIZE_MAX = 0x100000L;

        @NonNull
        public String getDisplayName() {
            return Messages.CustomFolderIcon_description();
        }

        @RequirePOST
        public HttpResponse doUploadIcon(StaplerRequest2 req, @AncestorInPath Item item) {
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            try {
                FileItem file = req.getFileItem2("file");
                if (file == null || file.getSize() == 0L) {
                    return HttpResponses.errorWithoutStack((int)500, (String)Messages.Upload_invalidFile());
                }
                if (file.getSize() > 0x100000L) {
                    return HttpResponses.errorWithoutStack((int)500, (String)Messages.Upload_exceedsFileSize(file.getSize(), 0x100000L));
                }
                String filename = String.valueOf(UUID.randomUUID()) + ".png";
                FilePath iconDir = Jenkins.get().getRootPath().child("userContent").child("customFolderIcons");
                iconDir.mkdirs();
                FilePath icon = iconDir.child(filename);
                icon.copyFrom(file.getInputStream());
                icon.chmod(420);
                return HttpResponses.text((String)filename);
            }
            catch (ServletException | IOException | InterruptedException ex) {
                LOGGER.log(Level.WARNING, "Error during Folder Icon upload!", ex);
                return HttpResponses.errorWithoutStack((int)500, (String)ex.getMessage());
            }
        }
    }

    @Extension
    public static class CustomFolderIconCleanup
    extends ItemListener {
        public void onDeleted(Item item) {
            CustomFolderIcon customFolderIcon;
            String foldericon;
            FolderIcon icon;
            if (item instanceof AbstractFolder && (icon = ((AbstractFolder)item).getIcon()) instanceof CustomFolderIcon && (foldericon = (customFolderIcon = (CustomFolderIcon)icon).getFoldericon()) != null && !foldericon.isBlank()) {
                boolean orphan;
                boolean bl = orphan = Jenkins.get().getAllItems(AbstractFolder.class).stream().filter(folder -> {
                    CustomFolderIcon customIcon;
                    FolderIcon patt0$temp = folder.getIcon();
                    return patt0$temp instanceof CustomFolderIcon && foldericon.equals((customIcon = (CustomFolderIcon)patt0$temp).getFoldericon());
                }).limit(2L).count() <= 1L;
                if (orphan) {
                    FilePath iconDir = Jenkins.get().getRootPath().child("userContent").child("customFolderIcons");
                    try {
                        if (!iconDir.child(foldericon).delete()) {
                            LOGGER.warning(() -> "Unable to delete Folder Icon '" + foldericon + "' for Folder '" + item.getFullName() + "'!");
                        }
                    }
                    catch (IOException | InterruptedException ex) {
                        LOGGER.log(Level.WARNING, ex, () -> "Unable to delete Folder Icon '" + foldericon + "' for Folder '" + item.getFullName() + "'!");
                    }
                }
            }
        }
    }
}

