/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.foldericon;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.util.FormValidation;
import java.util.Locale;
import jenkins.model.Jenkins;
import jenkins.plugins.foldericon.Messages;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class UrlFolderIcon
extends FolderIcon {
    private static final String DEFAULT_ICON_PATH = "plugin/custom-folder-icon/icons/default.svg";
    private final String url;
    private AbstractFolder<?> owner;

    @DataBoundConstructor
    public UrlFolderIcon(String url) {
        this.url = url;
    }

    protected void setOwner(AbstractFolder<?> folder) {
        this.owner = folder;
    }

    public String getUrl() {
        return this.url;
    }

    public String getImageOf(String size) {
        if (this.getUrl() != null && !this.getUrl().isBlank()) {
            return this.getUrl();
        }
        return Jenkins.get().getRootUrl() + DEFAULT_ICON_PATH;
    }

    public String getDescription() {
        if (this.owner != null) {
            return this.owner.getPronoun();
        }
        return Messages.Folder_description();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends FolderIconDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.UrlFolderIcon_description();
        }

        @RequirePOST
        public FormValidation doCheckUrl(@AncestorInPath Item item, @QueryParameter String value) {
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            if (value != null && !value.isBlank() && !value.toLowerCase(Locale.ROOT).startsWith("http")) {
                return FormValidation.error((String)Messages.Url_invalidUrl());
            }
            return FormValidation.ok();
        }
    }
}

