/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.foldericon;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.emoji.symbols.Emojis;
import jenkins.model.Jenkins;
import jenkins.plugins.foldericon.Messages;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class EmojiFolderIcon
extends FolderIcon {
    private static final String DEFAULT_ICON = "sloth";
    private final String emoji;
    private AbstractFolder<?> owner;

    @DataBoundConstructor
    public EmojiFolderIcon(String emoji) {
        this.emoji = StringUtils.isBlank((CharSequence)emoji) ? DEFAULT_ICON : emoji;
    }

    protected void setOwner(AbstractFolder<?> folder) {
        this.owner = folder;
    }

    public String getEmoji() {
        return this.emoji;
    }

    public String getImageOf(String size) {
        return null;
    }

    public String getIconClassName() {
        return Emojis.getIconClassName((String)this.getEmoji());
    }

    public String getDescription() {
        if (this.owner != null) {
            return this.owner.getPronoun();
        }
        return Messages.Folder_description();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends FolderIconDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.EmojiFolderIcon_description();
        }
    }
}

