/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.custombuildproperties.table;

import hudson.markup.MarkupFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.FastDateFormat;
import org.jenkinsci.plugins.custombuildproperties.SvgAwareSanitizer;
import org.jenkinsci.plugins.custombuildproperties.table.CbpTableCell;
import org.jenkinsci.plugins.custombuildproperties.table.CbpTableColumn;
import org.jenkinsci.plugins.custombuildproperties.table.CbpTableRow;

public class CbpTable {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss EEE");
    private final MarkupFormatter defaultMarkupFormatter;
    private final Pattern pattern;
    private final String name;
    private final String title;
    private final List<CbpTableColumn> columns = new ArrayList<CbpTableColumn>();
    private final Map<String, CbpTableColumn> columnsByName = new HashMap<String, CbpTableColumn>();
    private final List<CbpTableRow> rows = new ArrayList<CbpTableRow>();
    private final Map<String, CbpTableRow> rowsByName = new HashMap<String, CbpTableRow>();

    public CbpTable(String name, Pattern pattern, MarkupFormatter defaultMarkupFormatter) {
        this.defaultMarkupFormatter = defaultMarkupFormatter;
        this.pattern = pattern;
        this.name = name;
        this.title = this.sanitize(name, false);
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public List<CbpTableColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<CbpTableRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public void putValue(String rowName, String columnName, Object value, boolean sanitizeInternal) {
        CbpTableColumn column = this.getOrCreateColumn(columnName);
        CbpTableRow row = this.getOrCreateRow(rowName);
        CbpTableCell cell = row.getOrCreateCell(column);
        cell.setValue(this.sanitize(this.rawFormat(value), sanitizeInternal));
    }

    private CbpTableColumn getOrCreateColumn(String columnName) {
        return this.columnsByName.computeIfAbsent(columnName, notUsed -> {
            CbpTableColumn column = new CbpTableColumn();
            column.setTitle(this.sanitize(columnName, false));
            this.columns.add(column);
            return column;
        });
    }

    private CbpTableRow getOrCreateRow(String rowName) {
        return this.rowsByName.computeIfAbsent(rowName, notUsed -> {
            CbpTableRow row = new CbpTableRow();
            row.setTitle(this.sanitize(rowName, false));
            this.rows.add(row);
            return row;
        });
    }

    String sanitize(String content, boolean internal) {
        if (internal) {
            return SvgAwareSanitizer.sanitize(content);
        }
        try {
            return this.defaultMarkupFormatter.translate(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String rawFormat(Object value) {
        if (value instanceof Date || value instanceof Calendar) {
            return DATE_FORMAT.format(value);
        }
        return value == null ? "" : value.toString();
    }
}

