/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.custombuildproperties;

import hudson.model.Api;
import hudson.model.Item;
import hudson.model.Run;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.jenkinsci.plugins.custombuildproperties.CustomBuildPropertiesListener;
import org.jenkinsci.plugins.custombuildproperties.table.CbpTable;
import org.jenkinsci.plugins.custombuildproperties.table.CbpTablesFactory;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class CustomBuildPropertiesAction
implements RunAction2 {
    public static final String CBP_TABLE_PREFIX = "_cbp_table_";
    public static final String CBP_SANITIZER_PREFIX = "_cbp_sanitizer_";
    public static final String CBP_INTERNAL_SANITIZER = "internal";
    private static final Map<String, Function<String, ?>> SUPPORTED_REMOTE_TYPES;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private transient Run<?, ?> run;

    private static <T> void addRemoteType(Map<String, Function<String, ?>> map, Class<T> clazz, Function<String, T> parser) {
        map.put(clazz.getName(), parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported(visibility=2)
    public Map<String, Object> getProperties() {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return new HashMap<String, Object>(this.properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsProperty(String key) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.properties.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.properties.get(key);
        }
    }

    public Object setProperty(String key, Object newValue) {
        return this.setPropertyInternal(key, newValue, false, true);
    }

    public Object setPropertyIfAbsent(String key, Object newValue) {
        return this.setPropertyInternal(key, newValue, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CbpTable> getViewTables() {
        TreeMap<String, Object> clonedProperties;
        Map<String, Object> map = this.properties;
        synchronized (map) {
            clonedProperties = new TreeMap<String, Object>(this.properties);
        }
        return new CbpTablesFactory(clonedProperties, Jenkins.get().getMarkupFormatter()).createTables();
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public String getDisplayName() {
        return "Custom Build Properties";
    }

    public String getUrlName() {
        return "custombuildproperties";
    }

    public void doGet(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(required=true) String key) throws IOException, ServletException {
        this.run.checkPermission(Item.READ);
        Object value = this.getProperty(key);
        this.writeValue(rsp, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doSet(StaplerRequest2 req, StaplerResponse2 rsp) throws Exception {
        Object oldValue;
        this.run.checkPermission(Run.UPDATE);
        JSONObject submittedForm = req.getSubmittedForm();
        String key = submittedForm.getString("key");
        String value = submittedForm.getString("value");
        String valueType = submittedForm.optString("valueType", null);
        Object newValue = this.parseRemoteValue(value, valueType);
        Run<?, ?> run = this.run;
        synchronized (run) {
            oldValue = this.setPropertyInternal(key, newValue, false, false);
            this.run.save();
        }
        CustomBuildPropertiesListener.fireChanged(this.run, key, oldValue, newValue);
        this.writeValue(rsp, oldValue);
    }

    @Deprecated
    @RequirePOST
    public void doSetPost(StaplerRequest2 req, StaplerResponse2 rsp) throws Exception {
        this.doSet(req, rsp);
    }

    Object parseRemoteValue(String value, String valueType) {
        if (valueType == null) {
            return value;
        }
        Function<String, ?> parser = SUPPORTED_REMOTE_TYPES.get(valueType);
        if (parser == null) {
            throw new IllegalArgumentException("Unsupported valueType: " + valueType);
        }
        return parser.apply(value);
    }

    private void writeValue(StaplerResponse2 rsp, Object value) throws IOException {
        this.setHeaders(rsp);
        rsp.setContentType("text/plain;charset=UTF-8");
        rsp.getWriter().print(value);
        rsp.getWriter().close();
    }

    private void setHeaders(StaplerResponse2 rsp) {
        rsp.setHeader("X-Jenkins", Jenkins.VERSION);
        rsp.setHeader("X-Jenkins-Session", Jenkins.SESSION_HASH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setPropertyInternal(String key, Object newValue, boolean onlyIfAbsent, boolean fireEvent) {
        Object oldValue;
        Map<String, Object> map = this.properties;
        synchronized (map) {
            if (onlyIfAbsent && this.properties.containsKey(key)) {
                return null;
            }
            oldValue = this.properties.put(key, newValue);
        }
        if (fireEvent) {
            CustomBuildPropertiesListener.fireChanged(this.run, key, oldValue, newValue);
        }
        return oldValue;
    }

    static {
        LinkedHashMap map = new LinkedHashMap();
        CustomBuildPropertiesAction.addRemoteType(map, String.class, string -> string);
        CustomBuildPropertiesAction.addRemoteType(map, Boolean.class, BooleanUtils::toBoolean);
        CustomBuildPropertiesAction.addRemoteType(map, Byte.class, Byte::parseByte);
        CustomBuildPropertiesAction.addRemoteType(map, Short.class, Short::parseShort);
        CustomBuildPropertiesAction.addRemoteType(map, Integer.class, Integer::parseInt);
        CustomBuildPropertiesAction.addRemoteType(map, Long.class, Long::parseLong);
        CustomBuildPropertiesAction.addRemoteType(map, Float.class, Float::parseFloat);
        CustomBuildPropertiesAction.addRemoteType(map, Double.class, Double::parseDouble);
        CustomBuildPropertiesAction.addRemoteType(map, BigInteger.class, BigInteger::new);
        CustomBuildPropertiesAction.addRemoteType(map, BigDecimal.class, BigDecimal::new);
        CustomBuildPropertiesAction.addRemoteType(map, Date.class, string -> {
            Instant instant;
            TemporalAccessor parseBestResult = DateTimeFormatter.ISO_DATE_TIME.parseBest((CharSequence)string, ZonedDateTime::from, OffsetDateTime::from, LocalDateTime::from);
            if (parseBestResult instanceof ZonedDateTime) {
                instant = ((ZonedDateTime)parseBestResult).toInstant();
            } else if (parseBestResult instanceof OffsetDateTime) {
                instant = ((OffsetDateTime)parseBestResult).toInstant();
            } else if (parseBestResult instanceof LocalDateTime) {
                instant = ((LocalDateTime)parseBestResult).atZone(ZoneId.systemDefault()).toInstant();
            } else {
                throw new RuntimeException("Unexpected parseBestResult=" + String.valueOf(parseBestResult) + " for " + string);
            }
            return Date.from(instant);
        });
        CustomBuildPropertiesAction.addRemoteType(map, LocalTime.class, LocalTime::parse);
        CustomBuildPropertiesAction.addRemoteType(map, LocalDate.class, LocalDate::parse);
        CustomBuildPropertiesAction.addRemoteType(map, LocalDateTime.class, LocalDateTime::parse);
        CustomBuildPropertiesAction.addRemoteType(map, Instant.class, Instant::parse);
        CustomBuildPropertiesAction.addRemoteType(map, OffsetDateTime.class, OffsetDateTime::parse);
        CustomBuildPropertiesAction.addRemoteType(map, ZonedDateTime.class, ZonedDateTime::parse);
        SUPPORTED_REMOTE_TYPES = Collections.unmodifiableMap(map);
    }
}

