/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.custombuildproperties;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResultAction;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.custombuildproperties.SetCustomBuildPropertyStep;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class SetJUnitCountStep
extends Step {
    public static final String CBP_SUFFIX_PASSED_COUNT = "PassedCount";
    public static final String CBP_SUFFIX_FAILED_COUNT = "FailedCount";
    public static final String CBP_SUFFIX_FAILED_AGE = "FailedAge";
    private static final Logger LOGGER = Logger.getLogger(SetJUnitCountStep.class.getName());
    private final String keyPrefix;
    private final String include;
    private final String exclude;
    private boolean onlySetIfAbsent;

    @DataBoundConstructor
    public SetJUnitCountStep(String keyPrefix, String include, String exclude) {
        this.keyPrefix = keyPrefix;
        this.include = include;
        this.exclude = exclude;
    }

    public String getExclude() {
        return this.exclude;
    }

    public String getInclude() {
        return this.include;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public boolean isOnlySetIfAbsent() {
        return this.onlySetIfAbsent;
    }

    @DataBoundSetter
    public void setOnlySetIfAbsent(boolean onlySetIfAbsent) {
        this.onlySetIfAbsent = onlySetIfAbsent;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static final class Execution
    extends SynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient SetJUnitCountStep step;

        public Execution(SetJUnitCountStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void run() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            String keyPrefix = this.step.getKeyPrefix();
            String include = this.step.getInclude();
            String exclude = this.step.getExclude();
            boolean onlySetIfAbsent = this.step.isOnlySetIfAbsent();
            Pattern includePattern = include != null && include.trim().length() > 0 ? Pattern.compile(include) : null;
            Pattern excludePattern = exclude != null && exclude.trim().length() > 0 ? Pattern.compile(exclude) : null;
            Run run2 = run;
            synchronized (run2) {
                int[] passed = new int[]{0, 0};
                int[] failed = new int[]{0, 0};
                TestResultAction testResultAction = (TestResultAction)run.getAction(TestResultAction.class);
                if (testResultAction != null) {
                    passed = this.count(testResultAction.getPassedTests(), includePattern, excludePattern);
                    failed = this.count(testResultAction.getFailedTests(), includePattern, excludePattern);
                }
                SetCustomBuildPropertyStep.runLogic(keyPrefix + SetJUnitCountStep.CBP_SUFFIX_PASSED_COUNT, passed[0], onlySetIfAbsent, run);
                SetCustomBuildPropertyStep.runLogic(keyPrefix + SetJUnitCountStep.CBP_SUFFIX_FAILED_COUNT, failed[0], onlySetIfAbsent, run);
                SetCustomBuildPropertyStep.runLogic(keyPrefix + SetJUnitCountStep.CBP_SUFFIX_FAILED_AGE, failed[1], onlySetIfAbsent, run);
            }
            return null;
        }

        private int[] count(List<CaseResult> caseResults, Pattern includePattern, Pattern excludePattern) {
            int count = 0;
            int age = 0;
            if (caseResults != null) {
                for (CaseResult caseResult : caseResults) {
                    String className;
                    if (caseResult == null || (className = caseResult.getClassName()) == null || includePattern != null && !includePattern.matcher(className).matches() || excludePattern != null && excludePattern.matcher(className).matches()) continue;
                    age = Math.max(age, caseResult.getAge());
                    ++count;
                }
            }
            return new int[]{count, age};
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Set junit test result counts as custom build properties";
        }

        public String getFunctionName() {
            return "setJUnitCounts";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }
    }
}

