/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.custombuildproperties.table;

import hudson.markup.MarkupFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jenkinsci.plugins.custombuildproperties.table.CbpTable;

public class CbpTablesFactory {
    private final Map<String, Object> properties;
    private final MarkupFormatter defaultMarkupFormatter;
    private final Set<String> internalSanitizer = new HashSet<String>();
    private final List<CbpTable> tables = new ArrayList<CbpTable>();

    public CbpTablesFactory(Map<String, Object> properties, MarkupFormatter defaultMarkupFormatter) {
        this.properties = properties;
        this.defaultMarkupFormatter = defaultMarkupFormatter;
    }

    public List<CbpTable> createTables() {
        this.createTablesAndPopulateInternalSanitizer();
        this.putTableValues();
        return this.tables;
    }

    private void createTablesAndPopulateInternalSanitizer() {
        Iterator<Map.Entry<String, Object>> propertiesI = this.properties.entrySet().iterator();
        while (propertiesI.hasNext()) {
            Map.Entry<String, Object> property = propertiesI.next();
            String key = property.getKey();
            Object value = property.getValue();
            if (key == null || !(value instanceof String)) continue;
            if (key.startsWith("_cbp_table_")) {
                Pattern pattern;
                String name = key.substring("_cbp_table_".length());
                try {
                    pattern = Pattern.compile((String)value);
                }
                catch (PatternSyntaxException e) {
                    pattern = null;
                }
                if (pattern == null) continue;
                CbpTable table = new CbpTable(name, pattern, this.defaultMarkupFormatter);
                this.tables.add(table);
                propertiesI.remove();
                continue;
            }
            if (!key.startsWith("_cbp_sanitizer_") || !"internal".equals(value)) continue;
            this.internalSanitizer.add(key.substring("_cbp_sanitizer_".length()));
            propertiesI.remove();
        }
    }

    private void putTableValues() {
        Iterator<Map.Entry<String, Object>> propertiesI = this.properties.entrySet().iterator();
        while (propertiesI.hasNext()) {
            Map.Entry<String, Object> property = propertiesI.next();
            String key = property.getKey();
            Object value = property.getValue();
            if (key == null) continue;
            for (CbpTable table : this.tables) {
                Matcher matcher = table.getPattern().matcher(key);
                if (!matcher.matches() || matcher.groupCount() < 2) continue;
                String rowName = matcher.group(1);
                String columnName = matcher.group(2);
                this.putTableValue(table, rowName, columnName, value);
                propertiesI.remove();
            }
        }
        if (!this.properties.isEmpty()) {
            CbpTable table = new CbpTable("Key", null, this.defaultMarkupFormatter);
            this.tables.add(table);
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                this.putTableValue(table, entry.getKey(), "Value", entry.getValue());
            }
        }
    }

    private void putTableValue(CbpTable table, String rowName, String columnName, Object value) {
        boolean sanitizeInternal = this.internalSanitizer.contains(table.getName() + "_" + rowName + "_" + columnName);
        table.putValue(rowName, columnName, value, sanitizeInternal);
    }
}

