/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.custombuildproperties;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public class SvgAwareSanitizer {
    private static final Pattern EMPTY_ELEMENT_SYNTAX = Pattern.compile("<(polygon|path)(\\s[^/>]+)/>");
    private static final PolicyFactory POLICY;

    public static String sanitize(String content) {
        StringBuffer sb = new StringBuffer();
        Matcher contentMatcher = EMPTY_ELEMENT_SYNTAX.matcher(content);
        while (contentMatcher.find()) {
            contentMatcher.appendReplacement(sb, "<$1$2></$1>");
        }
        contentMatcher.appendTail(sb);
        content = sb.toString();
        return POLICY.sanitize(content);
    }

    static {
        PolicyFactory limitedSvg = new HtmlPolicyBuilder().allowElements(new String[]{"svg", "title", "g", "polygon", "path", "text"}).allowTextIn(new String[]{"title", "text"}).allowAttributes(new String[]{"width", "height", "viewBox", "xmlns"}).onElements(new String[]{"svg"}).allowAttributes(new String[]{"id", "class", "transform"}).onElements(new String[]{"g"}).allowAttributes(new String[]{"fill", "stroke", "stroke-dasharray"}).onElements(new String[]{"polygon", "path", "text"}).allowAttributes(new String[]{"x", "y"}).onElements(new String[]{"text"}).allowAttributes(new String[]{"points"}).onElements(new String[]{"polygon"}).allowAttributes(new String[]{"d"}).onElements(new String[]{"path"}).allowAttributes(new String[]{"text-anchor", "font-family", "font-size"}).onElements(new String[]{"text"}).requireRelNofollowOnLinks().toFactory();
        POLICY = Sanitizers.FORMATTING.and(limitedSvg);
    }
}

