/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.custombuildproperties;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.jenkinsci.plugins.custombuildproperties.CustomBuildPropertiesAction;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public final class GetCustomBuildPropertyStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(GetCustomBuildPropertyStep.class.getName());
    private final String key;

    @DataBoundConstructor
    public GetCustomBuildPropertyStep(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static final class Execution
    extends SynchronousStepExecution<Object> {
        private static final long serialVersionUID = 1L;
        private final String key;

        public Execution(GetCustomBuildPropertyStep step, StepContext context) {
            super(context);
            this.key = step.getKey();
        }

        protected Object run() throws Exception {
            CustomBuildPropertiesAction action;
            Run run = (Run)this.getContext().get(Run.class);
            do {
                if ((run = run.getPreviousBuild()) != null) continue;
                return null;
            } while ((action = (CustomBuildPropertiesAction)run.getAction(CustomBuildPropertiesAction.class)) == null || !action.containsProperty(this.key));
            return action.getProperty(this.key);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Get custom build property";
        }

        public String getFunctionName() {
            return "getCustomBuildProperty";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }
    }
}

