/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.csp.CustomRule;
import io.jenkins.plugins.csp.CustomRuleAdvancedConfiguration;
import io.jenkins.plugins.csp.CustomRuleDescriptor;
import io.jenkins.plugins.csp.rules.ValueSpecifier;
import java.util.Arrays;
import java.util.Optional;
import jenkins.model.Jenkins;
import jenkins.security.csp.CspBuilder;
import jenkins.security.csp.Directive;
import jenkins.security.csp.FetchDirective;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AllowFetchRule
extends CustomRule {
    private final String directive;
    private final ValueSpecifier allow;

    @DataBoundConstructor
    public AllowFetchRule(String directive, ValueSpecifier allow) {
        this.directive = directive;
        this.allow = allow;
    }

    public String getDirective() {
        return this.directive;
    }

    public ValueSpecifier getAllow() {
        return this.allow;
    }

    @Override
    public void apply(CspBuilder builder) {
        this.allow.apply(this.directive, builder);
    }

    @Symbol(value={"allowFetch"})
    @Extension
    public static class DescriptorImpl
    extends CustomRuleDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Allow additional fetch source";
        }

        @POST
        public FormValidation doCheckDirective(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (value == null || value.isEmpty()) {
                return FormValidation.ok();
            }
            if (FetchDirective.isFetchDirective((String)value)) {
                FetchDirective fetchDirective = FetchDirective.fromKey((String)value);
                Optional<Directive> directive = CustomRuleAdvancedConfiguration.getCurrentRules().stream().filter(it -> it.name().equals(value)).findFirst();
                if (directive.isEmpty()) {
                    return FormValidation.okWithMarkup((String)("This directive is currently undefined and would fall back to <code>" + Util.xmlEscape((String)fetchDirective.getFallback().toKey()) + "</code>."));
                }
                Directive effectiveDirective = directive.get();
                if (effectiveDirective.inheriting().booleanValue()) {
                    return FormValidation.okWithMarkup((String)("This directive inherits from from '<code>" + fetchDirective.getFallback().toKey() + "</code>'. Its current effective value is <code>" + Util.xmlEscape((String)String.join((CharSequence)" ", effectiveDirective.values())) + "</code>"));
                }
                return FormValidation.okWithMarkup((String)("This directive is non-inheriting. Its current effective value is <code>" + Util.xmlEscape((String)String.join((CharSequence)" ", effectiveDirective.values())) + "</code>"));
            }
            return FormValidation.error((String)("Not a known fetch directive: " + value));
        }

        @POST
        public ListBoxModel doFillDirectiveItems() {
            ListBoxModel model = new ListBoxModel();
            if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                Arrays.stream(FetchDirective.values()).map(FetchDirective::toKey).forEach(arg_0 -> ((ListBoxModel)model).add(arg_0));
            }
            return model;
        }
    }
}

