/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.csp.CspBuilder;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class ValueSpecifier
implements Describable<ValueSpecifier>,
ExtensionPoint {
    protected abstract String getValue();

    public void apply(String directive, CspBuilder builder) {
        builder.add(directive, new String[]{this.getValue()});
    }

    public static class ByDomain
    extends ValueSpecifier {
        private static final Logger LOGGER = Logger.getLogger(ByDomain.class.getName());
        private final String domain;

        @DataBoundConstructor
        public ByDomain(String domain) {
            this.domain = domain;
        }

        public String getDomain() {
            return this.domain;
        }

        @Override
        protected String getValue() {
            return "'" + this.domain + "'";
        }

        @Override
        public void apply(String directive, CspBuilder builder) {
            if (DescriptorImpl.checkDomainInternal((String)this.domain).kind == FormValidation.Kind.OK) {
                builder.add(directive, new String[]{this.domain});
            } else {
                LOGGER.log(Level.FINE, "Not adding invalid domain to " + directive + ": " + this.domain);
            }
        }

        @Extension
        public static class DescriptorImpl
        extends ValueSpecifierDescriptor {
            @NonNull
            public String getDisplayName() {
                return "Domain specification";
            }

            @POST
            public FormValidation doCheckDomain(@QueryParameter String value) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    return FormValidation.ok();
                }
                return DescriptorImpl.checkDomainInternal(value);
            }

            private static FormValidation checkDomainInternal(String domain) {
                if (domain == null || domain.trim().isEmpty()) {
                    return FormValidation.error((String)"Domain cannot be empty");
                }
                if (domain.matches("^(https?://)?([*]\\.|[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)*[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(:[0-9]{1,5})?$")) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Invalid domain format");
            }
        }
    }

    public static class Self
    extends ValueSpecifier {
        @DataBoundConstructor
        public Self() {
        }

        @Override
        protected String getValue() {
            return "'self'";
        }

        @Extension
        @Symbol(value={"self"})
        public static class DescriptorImpl
        extends ValueSpecifierDescriptor {
        }
    }

    public static class Blob
    extends Scheme {
        @DataBoundConstructor
        public Blob() {
        }

        @Extension
        @Symbol(value={"blobScheme"})
        public static class DescriptorImpl
        extends SchemeDescriptor {
        }
    }

    public static class Data
    extends Scheme {
        @DataBoundConstructor
        public Data() {
        }

        @Extension
        @Symbol(value={"dataScheme"})
        public static class DescriptorImpl
        extends SchemeDescriptor {
        }
    }

    private static abstract class SchemeDescriptor
    extends ValueSpecifierDescriptor {
        private SchemeDescriptor() {
        }

        @NonNull
        public String getDisplayName() {
            return "Scheme " + ((Object)((Object)this)).getClass().getEnclosingClass().getSimpleName().toLowerCase(Locale.ROOT) + ":";
        }
    }

    private static abstract class Scheme
    extends ValueSpecifier {
        private Scheme() {
        }

        @Override
        protected String getValue() {
            return this.getClass().getSimpleName().toLowerCase(Locale.ROOT) + ":";
        }
    }

    public static class UnsafeEval
    extends ValueSpecifier {
        @DataBoundConstructor
        public UnsafeEval() {
        }

        @Override
        protected String getValue() {
            return "'unsafe-eval'";
        }

        @Extension
        public static class DescriptorImpl
        extends ValueSpecifierDescriptor {
            @NonNull
            public String getDisplayName() {
                return "unsafe-eval";
            }
        }
    }

    public static class UnsafeInline
    extends ValueSpecifier {
        @DataBoundConstructor
        public UnsafeInline() {
        }

        @Override
        protected String getValue() {
            return "'unsafe-inline'";
        }

        @Extension
        public static class DescriptorImpl
        extends ValueSpecifierDescriptor {
            @NonNull
            public String getDisplayName() {
                return "unsafe-inline";
            }
        }
    }

    public static abstract class ValueSpecifierDescriptor
    extends Descriptor<ValueSpecifier> {
    }
}

