/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.model.ManagementLink;
import hudson.model.PeriodicWork;
import hudson.model.User;
import io.jenkins.plugins.csp.ReportingAdvancedConfiguration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.csp.AdvancedConfiguration;
import jenkins.security.csp.CspReceiver;
import jenkins.util.SystemProperties;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"contentSecurityPolicyManagementLink"})
public class ContentSecurityPolicyManagementLink
extends ManagementLink
implements StaplerProxy,
CspReceiver {
    public static final Logger LOGGER = Logger.getLogger(ContentSecurityPolicyManagementLink.class.getName());
    public static final int ROTATE_PERIOD_HOURS = SystemProperties.getInteger((String)(ContentSecurityPolicyManagementLink.class.getName() + ".ROTATE_PERIOD_HOURS"), (Integer)6);
    private static int ROTATE_AFTER_HOURS = SystemProperties.getInteger((String)(ContentSecurityPolicyManagementLink.class.getName() + ".ROTATE_AFTER_HOURS"), (Integer)24);
    private final List<Record> records = new LinkedList<Record>();
    @GuardedBy(value="records")
    private Instant start = Instant.now();

    public String getIconFileName() {
        return "document.png";
    }

    public String getDisplayName() {
        return "Content Security Policy Report";
    }

    public String getUrlName() {
        return "content-security-policy-reports";
    }

    public String getDescription() {
        return "Review reported Content Security Policy violations.";
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.SECURITY;
    }

    public Object getTarget() {
        Jenkins.get().checkPermission(this.getRequiredPermission());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(@NonNull CspReceiver.ViewContext viewContext, @CheckForNull String userId, @NonNull JSONObject report) {
        if (userId == null && AdvancedConfiguration.getCurrent(ReportingAdvancedConfiguration.class).map(ReportingAdvancedConfiguration::isIgnoreAnonymousReports).orElse(false).booleanValue()) {
            return;
        }
        JSONObject cspReport = report.getJSONObject("csp-report");
        String violatedDirective = cspReport.optString("violated-directive", "<UNKNOWN>");
        String blockedUri = cspReport.optString("blocked-uri", "<UNKNOWN>");
        String scriptSample = cspReport.optString("script-sample", "<UNKNOWN>");
        Record record = new Record(viewContext.className(), viewContext.viewName(), violatedDirective, blockedUri, scriptSample, Instant.now(), userId);
        List<Record> list = this.records;
        synchronized (list) {
            this.records.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> getRecords() {
        List<Record> list = this.records;
        synchronized (list) {
            return new ArrayList<Record>(this.records);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instant getStart() {
        List<Record> list = this.records;
        synchronized (list) {
            return this.start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public HttpResponse doClear() {
        List<Record> list = this.records;
        synchronized (list) {
            this.records.clear();
            this.start = Instant.now();
        }
        return HttpResponses.forwardToPreviousPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate() {
        List<Record> list = this.records;
        synchronized (list) {
            this.records.removeIf(r -> r.getTime().isBefore(Instant.now().minus(ROTATE_AFTER_HOURS, ChronoUnit.HOURS)));
        }
    }

    public static final class Record {
        private final String contextClassName;
        private final String contextViewName;
        private final String violatedDirective;
        private final String blockedUri;
        private final String scriptSample;
        private final Instant time;
        private final String username;

        public Record(String contextClassName, String contextViewName, String violatedDirective, String blockedUri, String scriptSample, Instant time, String username) {
            this.violatedDirective = violatedDirective;
            this.contextClassName = contextClassName;
            this.contextViewName = contextViewName;
            this.blockedUri = blockedUri;
            this.scriptSample = scriptSample;
            this.time = time;
            this.username = username;
        }

        public String getContextClassName() {
            return this.contextClassName;
        }

        public String getContextViewName() {
            return this.contextViewName;
        }

        public String getViolatedDirective() {
            return this.violatedDirective;
        }

        public String getBlockedUri() {
            return this.blockedUri;
        }

        public String getScriptSample() {
            return this.scriptSample;
        }

        public Instant getTime() {
            return this.time;
        }

        public Date getDate() {
            return Date.from(this.time);
        }

        public String getUsername() {
            return this.username;
        }

        public PluginWrapper getContextPlugin() {
            if (this.contextClassName.isEmpty()) {
                return null;
            }
            try {
                PluginManager pluginManager = Jenkins.get().getPluginManager();
                return pluginManager.whichPlugin(pluginManager.uberClassLoader.loadClass(this.contextClassName));
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.FINE, e, () -> "Failed to determine plugin for class: " + this.contextClassName);
                return null;
            }
        }

        public User getUser() {
            if (this.username == null) {
                return null;
            }
            return User.get((String)this.username, (boolean)false, Collections.emptyMap());
        }
    }

    @Extension
    public static class Rotator
    extends PeriodicWork {
        public long getRecurrencePeriod() {
            return TimeUnit.HOURS.toMillis(ROTATE_PERIOD_HOURS);
        }

        protected void doRun() throws Exception {
            ((ContentSecurityPolicyManagementLink)((Object)ExtensionList.lookupSingleton(ContentSecurityPolicyManagementLink.class))).rotate();
        }
    }
}

