/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.csp.CustomRule;
import io.jenkins.plugins.csp.CustomRuleAdvancedConfiguration;
import io.jenkins.plugins.csp.CustomRuleDescriptor;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.csp.CspBuilder;
import jenkins.security.csp.Directive;
import jenkins.security.csp.FetchDirective;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AllowFetchRule
extends CustomRule {
    private final String directive;
    private final ValueSpecifier allow;

    @DataBoundConstructor
    public AllowFetchRule(String directive, ValueSpecifier allow) {
        this.directive = directive;
        this.allow = allow;
    }

    public String getDirective() {
        return this.directive;
    }

    public ValueSpecifier getAllow() {
        return this.allow;
    }

    @Override
    public void apply(CspBuilder builder) {
        this.allow.apply(this.directive, builder);
    }

    public static abstract class ValueSpecifier
    implements Describable<ValueSpecifier>,
    ExtensionPoint {
        abstract String getValue();

        public void apply(String directive, CspBuilder builder) {
            builder.add(directive, new String[]{this.getValue()});
        }
    }

    public static class ByDomain
    extends ValueSpecifier {
        private final String domain;

        @DataBoundConstructor
        public ByDomain(String domain) {
            this.domain = domain;
        }

        public String getDomain() {
            return this.domain;
        }

        @Override
        String getValue() {
            return "'" + this.domain + "'";
        }

        @Override
        public void apply(String directive, CspBuilder builder) {
            if (((DescriptorImpl)((Object)ExtensionList.lookupSingleton(DescriptorImpl.class))).doCheckDomain((String)this.domain).kind == FormValidation.Kind.OK) {
                builder.add(directive, new String[]{this.domain});
            } else {
                Logger.getLogger(ByDomain.class.getName()).log(Level.FINE, "Not adding invalid domain to " + directive + ": " + this.domain);
            }
        }

        @Extension
        public static class DescriptorImpl
        extends ValueSpecifierDescriptor {
            @NonNull
            public String getDisplayName() {
                return "Domain specification";
            }

            @POST
            public FormValidation doCheckDomain(@QueryParameter String value) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    return FormValidation.ok();
                }
                if (value == null || value.trim().isEmpty()) {
                    return FormValidation.error((String)"Domain cannot be empty");
                }
                if (value.matches("^(https?://)?([*]\\.|[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)*[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?(:[0-9]{1,5})?$")) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"Invalid domain format");
            }
        }
    }

    public static class Self
    extends ValueSpecifier {
        @DataBoundConstructor
        public Self() {
        }

        @Override
        String getValue() {
            return "'self'";
        }

        @Extension
        @Symbol(value={"self"})
        public static class DescriptorImpl
        extends ValueSpecifierDescriptor {
        }
    }

    public static class Blob
    extends Scheme {
        @DataBoundConstructor
        public Blob() {
        }

        @Extension
        @Symbol(value={"blobScheme"})
        public static class DescriptorImpl
        extends SchemeDescriptor {
        }
    }

    public static class Data
    extends Scheme {
        @DataBoundConstructor
        public Data() {
        }

        @Extension
        @Symbol(value={"dataScheme"})
        public static class DescriptorImpl
        extends SchemeDescriptor {
        }
    }

    private static abstract class SchemeDescriptor
    extends ValueSpecifierDescriptor {
        private SchemeDescriptor() {
        }

        @NonNull
        public String getDisplayName() {
            return "Scheme " + ((Object)((Object)this)).getClass().getEnclosingClass().getSimpleName().toLowerCase(Locale.ROOT) + ":";
        }
    }

    private static abstract class Scheme
    extends ValueSpecifier {
        private Scheme() {
        }

        @Override
        String getValue() {
            return this.getClass().getSimpleName().toLowerCase(Locale.ROOT) + ":";
        }
    }

    public static class UnsafeEval
    extends ValueSpecifier {
        @DataBoundConstructor
        public UnsafeEval() {
        }

        @Override
        String getValue() {
            return "'unsafe-eval'";
        }

        @Extension
        public static class DescriptorImpl
        extends ValueSpecifierDescriptor {
            @NonNull
            public String getDisplayName() {
                return "unsafe-eval";
            }
        }
    }

    public static class UnsafeInline
    extends ValueSpecifier {
        @DataBoundConstructor
        public UnsafeInline() {
        }

        @Override
        String getValue() {
            return "'unsafe-inline'";
        }

        @Extension
        public static class DescriptorImpl
        extends ValueSpecifierDescriptor {
            @NonNull
            public String getDisplayName() {
                return "unsafe-inline";
            }
        }
    }

    public static abstract class ValueSpecifierDescriptor
    extends Descriptor<ValueSpecifier> {
    }

    @Symbol(value={"allowFetch"})
    @Extension
    public static class DescriptorImpl
    extends CustomRuleDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Allow additional fetch source";
        }

        @POST
        public FormValidation doCheckDirective(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (value == null || value.isEmpty()) {
                return FormValidation.ok();
            }
            if (FetchDirective.isFetchDirective((String)value)) {
                FetchDirective fetchDirective = FetchDirective.fromKey((String)value);
                Optional<Directive> directive = CustomRuleAdvancedConfiguration.getCurrentRules().stream().filter(it -> it.name().equals(value)).findFirst();
                if (directive.isEmpty()) {
                    return FormValidation.okWithMarkup((String)("This directive is currently undefined and would fall back to <code>" + Util.xmlEscape((String)fetchDirective.getFallback().toKey()) + "</code>."));
                }
                Directive effectiveDirective = directive.get();
                if (effectiveDirective.inheriting().booleanValue()) {
                    return FormValidation.okWithMarkup((String)("This directive inherits from from '<code>" + fetchDirective.getFallback().toKey() + "</code>'. Its current effective value is <code>" + Util.xmlEscape((String)String.join((CharSequence)" ", effectiveDirective.values())) + "</code>"));
                }
                return FormValidation.okWithMarkup((String)("This directive is non-inheriting. Its current effective value is <code>" + Util.xmlEscape((String)String.join((CharSequence)" ", effectiveDirective.values())) + "</code>"));
            }
            return FormValidation.error((String)("Not a known fetch directive: " + value));
        }

        @POST
        public ListBoxModel doFillDirectiveItems() {
            ListBoxModel model = new ListBoxModel();
            if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                Arrays.stream(FetchDirective.values()).map(FetchDirective::toKey).forEach(arg_0 -> ((ListBoxModel)model).add(arg_0));
            }
            return model;
        }
    }
}

