/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.csp.CustomRule;
import io.jenkins.plugins.csp.CustomRuleDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import jenkins.model.Jenkins;
import jenkins.security.csp.CspBuilder;
import jenkins.security.csp.CspHeader;
import jenkins.security.csp.FetchDirective;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ResetRule
extends CustomRule {
    private final String directive;
    private final boolean disableInheritance;

    @DataBoundConstructor
    public ResetRule(String directive, boolean disableInheritance) {
        this.directive = directive;
        this.disableInheritance = disableInheritance;
    }

    public String getDirective() {
        return this.directive;
    }

    @Override
    public void apply(CspBuilder builder) {
        builder.remove(this.directive, new String[0]);
        FetchDirective.toFetchDirective((String)this.directive).ifPresent(fd -> {
            if (this.isDisableInheritance()) {
                builder.initialize(fd, new String[0]);
            }
        });
    }

    public boolean isDisableInheritance() {
        return this.disableInheritance;
    }

    @Symbol(value={"reset"})
    @Extension
    public static class DescriptorImpl
    extends CustomRuleDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Reset directive";
        }

        @POST
        public ListBoxModel doFillDirectiveItems() {
            ListBoxModel model = new ListBoxModel();
            if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                Arrays.stream(FetchDirective.values()).map(FetchDirective::toKey).forEach(arg_0 -> ((ListBoxModel)model).add(arg_0));
            }
            List.of("form-action", "frame-ancestors").forEach(arg_0 -> ((ListBoxModel)model).add(arg_0));
            return model;
        }

        public FormValidation doCheckDirective(@QueryParameter String value, @QueryParameter boolean disableInheritance) {
            return FetchDirective.toFetchDirective((String)value).map(fd -> {
                if (List.of(FetchDirective.DEFAULT_SRC, FetchDirective.IMG_SRC, FetchDirective.SCRIPT_SRC, FetchDirective.STYLE_SRC).contains(fd)) {
                    return FormValidation.warningWithMarkup((String)("Resetting " + fd.toKey() + " to 'none' is discouraged. The Jenkins UI may break unless you're careful. If this happens, you can restart Jenkins with the Java system property '<code>" + CspHeader.class.getName() + ".selectedHeaderName</code>' set to '<code>Content-Security-Policy-Report-Only</code>' to recover."));
                }
                if (disableInheritance && fd.getFallback() != null && (List.of(FetchDirective.STYLE_SRC, FetchDirective.SCRIPT_SRC).contains(fd.getFallback()) || Objects.equals(FetchDirective.CONNECT_SRC, fd))) {
                    return FormValidation.warningWithMarkup((String)("Resetting " + fd.toKey() + " to 'none' with disabled inheritance is discouraged. The Jenkins UI may break unless you're careful. If this happens, you can restart Jenkins with the Java system property '<code>" + CspHeader.class.getName() + ".selectedHeaderName</code>' set to '<code>Content-Security-Policy-Report-Only</code>' to recover."));
                }
                return FormValidation.ok();
            }).orElse(FormValidation.ok());
        }

        public FormValidation doCheckDisableInheritance(@QueryParameter boolean value, @QueryParameter String directive) {
            if (value && !FetchDirective.isFetchDirective((String)directive)) {
                return FormValidation.warningWithMarkup((String)("The directive '<code>" + Util.xmlEscape((String)directive) + "</code>' is not a fetch directive with inheritance, so the inheritance option has no effect."));
            }
            return FormValidation.ok();
        }
    }
}

