/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.csp.CustomRule;
import io.jenkins.plugins.csp.CustomRuleDescriptor;
import io.jenkins.plugins.csp.rules.ValueSpecifier;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.security.csp.CspBuilder;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.verb.POST;

public class AllowNavigationRule
extends CustomRule {
    private final String directive;
    private final ValueSpecifier allow;

    @DataBoundConstructor
    public AllowNavigationRule(String directive, ValueSpecifier allow) {
        this.directive = directive;
        this.allow = allow;
    }

    public String getDirective() {
        return this.directive;
    }

    public ValueSpecifier getAllow() {
        return this.allow;
    }

    @Override
    public void apply(CspBuilder builder) {
        this.allow.apply(this.directive, builder);
    }

    @Symbol(value={"allowNavigation"})
    @Extension
    public static class DescriptorImpl
    extends CustomRuleDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Allow additional navigation source";
        }

        public List<Descriptor<ValueSpecifier>> getAllowDescriptors() {
            return Jenkins.get().getDescriptorList(ValueSpecifier.class).stream().filter(d -> d instanceof ValueSpecifier.ByDomain.DescriptorImpl || d instanceof ValueSpecifier.Self.DescriptorImpl).toList();
        }

        @POST
        public ListBoxModel doFillDirectiveItems() {
            ListBoxModel model = new ListBoxModel();
            if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                List.of("form-action", "frame-ancestors").forEach(arg_0 -> ((ListBoxModel)model).add(arg_0));
            }
            return model;
        }
    }
}

