/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.csp;

import hudson.Extension;
import hudson.model.Saveable;
import hudson.util.DescribableList;
import io.jenkins.plugins.csp.CustomRule;
import io.jenkins.plugins.csp.CustomRuleDescriptor;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jenkins.security.csp.AdvancedConfiguration;
import jenkins.security.csp.AdvancedConfigurationDescriptor;
import jenkins.security.csp.CspBuilder;
import jenkins.security.csp.Directive;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CustomRuleAdvancedConfiguration
extends AdvancedConfiguration {
    private DescribableList<CustomRule, CustomRuleDescriptor> rules = new DescribableList(Saveable.NOOP);

    @DataBoundConstructor
    public CustomRuleAdvancedConfiguration() {
    }

    public List<CustomRule> getRules() {
        return this.rules;
    }

    @DataBoundSetter
    public void setRules(List<CustomRule> rules) throws IOException {
        this.rules.replaceBy(rules);
    }

    public static Map<String, String> getCurrentEffectiveRules() {
        return new CspBuilder().withDefaultContributions().buildDirectives();
    }

    public static List<Directive> getCurrentRules() {
        return new CspBuilder().withDefaultContributions().getMergedDirectives().stream().sorted(Comparator.comparing(Directive::name)).toList();
    }

    @Extension
    @Symbol(value={"custom"})
    public static class DescriptorImpl
    extends AdvancedConfigurationDescriptor {
    }
}

