// CHECKSTYLE:OFF

package io.jenkins.plugins.coverage.metrics.steps;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ChecksAnnotationScope.ModifiedLines}: {@code Publish

     * annotations for modified lines}.
     * 
     * @return
     *     {@code Publish annotations for modified lines}
     */
    public static String ChecksAnnotationScope_ModifiedLines() {
        return holder.format("ChecksAnnotationScope.ModifiedLines");
    }

    /**
     * Key {@code ChecksAnnotationScope.ModifiedLines}: {@code Publish

     * annotations for modified lines}.
     * 
     * @return
     *     {@code Publish annotations for modified lines}
     */
    public static Localizable _ChecksAnnotationScope_ModifiedLines() {
        return new Localizable(holder, "ChecksAnnotationScope.ModifiedLines");
    }

    /**
     * Key {@code ChecksAnnotationScope.AllLines}: {@code Publish annotations

     * for all lines}.
     * 
     * @return
     *     {@code Publish annotations for all lines}
     */
    public static String ChecksAnnotationScope_AllLines() {
        return holder.format("ChecksAnnotationScope.AllLines");
    }

    /**
     * Key {@code ChecksAnnotationScope.AllLines}: {@code Publish annotations

     * for all lines}.
     * 
     * @return
     *     {@code Publish annotations for all lines}
     */
    public static Localizable _ChecksAnnotationScope_AllLines() {
        return new Localizable(holder, "ChecksAnnotationScope.AllLines");
    }

    /**
     * Key {@code Parser.PIT}: {@code PIT Mutation Testing Reports}.
     * 
     * @return
     *     {@code PIT Mutation Testing Reports}
     */
    public static String Parser_PIT() {
        return holder.format("Parser.PIT");
    }

    /**
     * Key {@code Parser.PIT}: {@code PIT Mutation Testing Reports}.
     * 
     * @return
     *     {@code PIT Mutation Testing Reports}
     */
    public static Localizable _Parser_PIT() {
        return new Localizable(holder, "Parser.PIT");
    }

    /**
     * Key {@code Checks.ProjectOverview}: {@code Project Coverage Summary}.
     * 
     * @return
     *     {@code Project Coverage Summary}
     */
    public static String Checks_ProjectOverview() {
        return holder.format("Checks.ProjectOverview");
    }

    /**
     * Key {@code Checks.ProjectOverview}: {@code Project Coverage Summary}.
     * 
     * @return
     *     {@code Project Coverage Summary}
     */
    public static Localizable _Checks_ProjectOverview() {
        return new Localizable(holder, "Checks.ProjectOverview");
    }

    /**
     * Key {@code Parser.JaCoCo}: {@code JaCoCo Coverage Reports}.
     * 
     * @return
     *     {@code JaCoCo Coverage Reports}
     */
    public static String Parser_JaCoCo() {
        return holder.format("Parser.JaCoCo");
    }

    /**
     * Key {@code Parser.JaCoCo}: {@code JaCoCo Coverage Reports}.
     * 
     * @return
     *     {@code JaCoCo Coverage Reports}
     */
    public static Localizable _Parser_JaCoCo() {
        return new Localizable(holder, "Parser.JaCoCo");
    }

    /**
     * Key {@code Column.Ncss}: {@code NCSS}.
     * 
     * @return
     *     {@code NCSS}
     */
    public static String Column_Ncss() {
        return holder.format("Column.Ncss");
    }

    /**
     * Key {@code Column.Ncss}: {@code NCSS}.
     * 
     * @return
     *     {@code NCSS}
     */
    public static Localizable _Column_Ncss() {
        return new Localizable(holder, "Column.Ncss");
    }

    /**
     * Key {@code Coverage.Title}: {@code Coverage of ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage of ''{0}''}
     */
    public static String Coverage_Title(Object arg0) {
        return holder.format("Coverage.Title", arg0);
    }

    /**
     * Key {@code Coverage.Title}: {@code Coverage of ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage of ''{0}''}
     */
    public static Localizable _Coverage_Title(Object arg0) {
        return new Localizable(holder, "Coverage.Title", arg0);
    }

    /**
     * Key {@code Column.Tests}: {@code Tests}.
     * 
     * @return
     *     {@code Tests}
     */
    public static String Column_Tests() {
        return holder.format("Column.Tests");
    }

    /**
     * Key {@code Column.Tests}: {@code Tests}.
     * 
     * @return
     *     {@code Tests}
     */
    public static Localizable _Column_Tests() {
        return new Localizable(holder, "Column.Tests");
    }

    /**
     * Key {@code Parser.Metrics}: {@code Metric Reports}.
     * 
     * @return
     *     {@code Metric Reports}
     */
    public static String Parser_Metrics() {
        return holder.format("Parser.Metrics");
    }

    /**
     * Key {@code Parser.Metrics}: {@code Metric Reports}.
     * 
     * @return
     *     {@code Metric Reports}
     */
    public static Localizable _Parser_Metrics() {
        return new Localizable(holder, "Parser.Metrics");
    }

    /**
     * Key {@code Checks.Annotation.Title}: {@code Missing Coverage}.
     * 
     * @return
     *     {@code Missing Coverage}
     */
    public static String Checks_Annotation_Title() {
        return holder.format("Checks.Annotation.Title");
    }

    /**
     * Key {@code Checks.Annotation.Title}: {@code Missing Coverage}.
     * 
     * @return
     *     {@code Missing Coverage}
     */
    public static Localizable _Checks_Annotation_Title() {
        return new Localizable(holder, "Checks.Annotation.Title");
    }

    /**
     * Key {@code Parser.Nunit}: {@code NUnit Test Results}.
     * 
     * @return
     *     {@code NUnit Test Results}
     */
    public static String Parser_Nunit() {
        return holder.format("Parser.Nunit");
    }

    /**
     * Key {@code Parser.Nunit}: {@code NUnit Test Results}.
     * 
     * @return
     *     {@code NUnit Test Results}
     */
    public static Localizable _Parser_Nunit() {
        return new Localizable(holder, "Parser.Nunit");
    }

    /**
     * Key {@code Parser.LCOV}: {@code LCOV Test Results}.
     * 
     * @return
     *     {@code LCOV Test Results}
     */
    public static String Parser_LCOV() {
        return holder.format("Parser.LCOV");
    }

    /**
     * Key {@code Parser.LCOV}: {@code LCOV Test Results}.
     * 
     * @return
     *     {@code LCOV Test Results}
     */
    public static Localizable _Parser_LCOV() {
        return new Localizable(holder, "Parser.LCOV");
    }

    /**
     * Key {@code Parser.Junit}: {@code JUnit Test Results}.
     * 
     * @return
     *     {@code JUnit Test Results}
     */
    public static String Parser_Junit() {
        return holder.format("Parser.Junit");
    }

    /**
     * Key {@code Parser.Junit}: {@code JUnit Test Results}.
     * 
     * @return
     *     {@code JUnit Test Results}
     */
    public static Localizable _Parser_Junit() {
        return new Localizable(holder, "Parser.Junit");
    }

    /**
     * Key {@code Column.TestStrength}: {@code Test Strength}.
     * 
     * @return
     *     {@code Test Strength}
     */
    public static String Column_TestStrength() {
        return holder.format("Column.TestStrength");
    }

    /**
     * Key {@code Column.TestStrength}: {@code Test Strength}.
     * 
     * @return
     *     {@code Test Strength}
     */
    public static Localizable _Column_TestStrength() {
        return new Localizable(holder, "Column.TestStrength");
    }

    /**
     * Key {@code Column.DeltaBranchCoverage}: {@code Branch {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Branch {0}}
     */
    public static String Column_DeltaBranchCoverage(Object arg0) {
        return holder.format("Column.DeltaBranchCoverage", arg0);
    }

    /**
     * Key {@code Column.DeltaBranchCoverage}: {@code Branch {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Branch {0}}
     */
    public static Localizable _Column_DeltaBranchCoverage(Object arg0) {
        return new Localizable(holder, "Column.DeltaBranchCoverage", arg0);
    }

    /**
     * Key {@code Column.LinesOfCode}: {@code LOC}.
     * 
     * @return
     *     {@code LOC}
     */
    public static String Column_LinesOfCode() {
        return holder.format("Column.LinesOfCode");
    }

    /**
     * Key {@code Column.LinesOfCode}: {@code LOC}.
     * 
     * @return
     *     {@code LOC}
     */
    public static Localizable _Column_LinesOfCode() {
        return new Localizable(holder, "Column.LinesOfCode");
    }

    /**
     * Key {@code Checks.Annotation.Message.MultiLine}: {@code Changed lines

     * #L{0} - L{1} are not covered by tests}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Changed lines #L{0} - L{1} are not covered by tests}
     */
    public static String Checks_Annotation_Message_MultiLine(Object arg0, Object arg1) {
        return holder.format("Checks.Annotation.Message.MultiLine", arg0, arg1);
    }

    /**
     * Key {@code Checks.Annotation.Message.MultiLine}: {@code Changed lines

     * #L{0} - L{1} are not covered by tests}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Changed lines #L{0} - L{1} are not covered by tests}
     */
    public static Localizable _Checks_Annotation_Message_MultiLine(Object arg0, Object arg1) {
        return new Localizable(holder, "Checks.Annotation.Message.MultiLine", arg0, arg1);
    }

    /**
     * Key {@code Column.BranchCoverage}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static String Column_BranchCoverage() {
        return holder.format("Column.BranchCoverage");
    }

    /**
     * Key {@code Column.BranchCoverage}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static Localizable _Column_BranchCoverage() {
        return new Localizable(holder, "Column.BranchCoverage");
    }

    /**
     * Key {@code Column.DeltaTestStrength}: {@code Test Strength {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test Strength {0}}
     */
    public static String Column_DeltaTestStrength(Object arg0) {
        return holder.format("Column.DeltaTestStrength", arg0);
    }

    /**
     * Key {@code Column.DeltaTestStrength}: {@code Test Strength {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Test Strength {0}}
     */
    public static Localizable _Column_DeltaTestStrength(Object arg0) {
        return new Localizable(holder, "Column.DeltaTestStrength", arg0);
    }

    /**
     * Key {@code Coverage.Trend.Default.Name}: {@code Code Coverage Trend}.
     * 
     * @return
     *     {@code Code Coverage Trend}
     */
    public static String Coverage_Trend_Default_Name() {
        return holder.format("Coverage.Trend.Default.Name");
    }

    /**
     * Key {@code Coverage.Trend.Default.Name}: {@code Code Coverage Trend}.
     * 
     * @return
     *     {@code Code Coverage Trend}
     */
    public static Localizable _Coverage_Trend_Default_Name() {
        return new Localizable(holder, "Coverage.Trend.Default.Name");
    }

    /**
     * Key {@code Column.MutationCoverage}: {@code Mutation}.
     * 
     * @return
     *     {@code Mutation}
     */
    public static String Column_MutationCoverage() {
        return holder.format("Column.MutationCoverage");
    }

    /**
     * Key {@code Column.MutationCoverage}: {@code Mutation}.
     * 
     * @return
     *     {@code Mutation}
     */
    public static Localizable _Column_MutationCoverage() {
        return new Localizable(holder, "Column.MutationCoverage");
    }

    /**
     * Key {@code MessagesViewModel.Title}: {@code Code Coverage}.
     * 
     * @return
     *     {@code Code Coverage}
     */
    public static String MessagesViewModel_Title() {
        return holder.format("MessagesViewModel.Title");
    }

    /**
     * Key {@code MessagesViewModel.Title}: {@code Code Coverage}.
     * 
     * @return
     *     {@code Code Coverage}
     */
    public static Localizable _MessagesViewModel_Title() {
        return new Localizable(holder, "MessagesViewModel.Title");
    }

    /**
     * Key {@code Change_Coverage_Delta_Type}: {@code Change Coverage Delta}.
     * 
     * @return
     *     {@code Change Coverage Delta}
     */
    public static String Change_Coverage_Delta_Type() {
        return holder.format("Change_Coverage_Delta_Type");
    }

    /**
     * Key {@code Change_Coverage_Delta_Type}: {@code Change Coverage Delta}.
     * 
     * @return
     *     {@code Change Coverage Delta}
     */
    public static Localizable _Change_Coverage_Delta_Type() {
        return new Localizable(holder, "Change_Coverage_Delta_Type");
    }

    /**
     * Key {@code Coverage_Column}: {@code Coverage}.
     * 
     * @return
     *     {@code Coverage}
     */
    public static String Coverage_Column() {
        return holder.format("Coverage_Column");
    }

    /**
     * Key {@code Coverage_Column}: {@code Coverage}.
     * 
     * @return
     *     {@code Coverage}
     */
    public static Localizable _Coverage_Column() {
        return new Localizable(holder, "Coverage_Column");
    }

    /**
     * Key {@code Column.NPath}: {@code NPath}.
     * 
     * @return
     *     {@code NPath}
     */
    public static String Column_NPath() {
        return holder.format("Column.NPath");
    }

    /**
     * Key {@code Column.NPath}: {@code NPath}.
     * 
     * @return
     *     {@code NPath}
     */
    public static Localizable _Column_NPath() {
        return new Localizable(holder, "Column.NPath");
    }

    /**
     * Key {@code Column.Package}: {@code Package}.
     * 
     * @return
     *     {@code Package}
     */
    public static String Column_Package() {
        return holder.format("Column.Package");
    }

    /**
     * Key {@code Column.Package}: {@code Package}.
     * 
     * @return
     *     {@code Package}
     */
    public static Localizable _Column_Package() {
        return new Localizable(holder, "Column.Package");
    }

    /**
     * Key {@code Column.MCDCPairs}: {@code MC/DC Pairs}.
     * 
     * @return
     *     {@code MC/DC Pairs}
     */
    public static String Column_MCDCPairs() {
        return holder.format("Column.MCDCPairs");
    }

    /**
     * Key {@code Column.MCDCPairs}: {@code MC/DC Pairs}.
     * 
     * @return
     *     {@code MC/DC Pairs}
     */
    public static Localizable _Column_MCDCPairs() {
        return new Localizable(holder, "Column.MCDCPairs");
    }

    /**
     * Key {@code Project_Coverage_Delta_Type}: {@code Project Coverage

     * Delta}.
     * 
     * @return
     *     {@code Project Coverage Delta}
     */
    public static String Project_Coverage_Delta_Type() {
        return holder.format("Project_Coverage_Delta_Type");
    }

    /**
     * Key {@code Project_Coverage_Delta_Type}: {@code Project Coverage

     * Delta}.
     * 
     * @return
     *     {@code Project Coverage Delta}
     */
    public static Localizable _Project_Coverage_Delta_Type() {
        return new Localizable(holder, "Project_Coverage_Delta_Type");
    }

    /**
     * Key {@code Coverage.Not.Available}: {@code N/A}.
     * 
     * @return
     *     {@code N/A}
     */
    public static String Coverage_Not_Available() {
        return holder.format("Coverage.Not.Available");
    }

    /**
     * Key {@code Coverage.Not.Available}: {@code N/A}.
     * 
     * @return
     *     {@code N/A}
     */
    public static Localizable _Coverage_Not_Available() {
        return new Localizable(holder, "Coverage.Not.Available");
    }

    /**
     * Key {@code Change_Coverage_Type}: {@code Change Coverage}.
     * 
     * @return
     *     {@code Change Coverage}
     */
    public static String Change_Coverage_Type() {
        return holder.format("Change_Coverage_Type");
    }

    /**
     * Key {@code Change_Coverage_Type}: {@code Change Coverage}.
     * 
     * @return
     *     {@code Change Coverage}
     */
    public static Localizable _Change_Coverage_Type() {
        return new Localizable(holder, "Change_Coverage_Type");
    }

    /**
     * Key {@code Project_Coverage_Type}: {@code Project Coverage}.
     * 
     * @return
     *     {@code Project Coverage}
     */
    public static String Project_Coverage_Type() {
        return holder.format("Project_Coverage_Type");
    }

    /**
     * Key {@code Project_Coverage_Type}: {@code Project Coverage}.
     * 
     * @return
     *     {@code Project Coverage}
     */
    public static Localizable _Project_Coverage_Type() {
        return new Localizable(holder, "Project_Coverage_Type");
    }

    /**
     * Key {@code Parser.VectorCAST}: {@code VectorCAST Coverage Results}.
     * 
     * @return
     *     {@code VectorCAST Coverage Results}
     */
    public static String Parser_VectorCAST() {
        return holder.format("Parser.VectorCAST");
    }

    /**
     * Key {@code Parser.VectorCAST}: {@code VectorCAST Coverage Results}.
     * 
     * @return
     *     {@code VectorCAST Coverage Results}
     */
    public static Localizable _Parser_VectorCAST() {
        return new Localizable(holder, "Parser.VectorCAST");
    }

    /**
     * Key {@code ChecksAnnotationScope.Skip}: {@code Skip annotations}.
     * 
     * @return
     *     {@code Skip annotations}
     */
    public static String ChecksAnnotationScope_Skip() {
        return holder.format("ChecksAnnotationScope.Skip");
    }

    /**
     * Key {@code ChecksAnnotationScope.Skip}: {@code Skip annotations}.
     * 
     * @return
     *     {@code Skip annotations}
     */
    public static Localizable _ChecksAnnotationScope_Skip() {
        return new Localizable(holder, "ChecksAnnotationScope.Skip");
    }

    /**
     * Key {@code Checks.Annotation.Message.SingleLine}: {@code Changed line

     * #L{0} is not covered by tests}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Changed line #L{0} is not covered by tests}
     */
    public static String Checks_Annotation_Message_SingleLine(Object arg0) {
        return holder.format("Checks.Annotation.Message.SingleLine", arg0);
    }

    /**
     * Key {@code Checks.Annotation.Message.SingleLine}: {@code Changed line

     * #L{0} is not covered by tests}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Changed line #L{0} is not covered by tests}
     */
    public static Localizable _Checks_Annotation_Message_SingleLine(Object arg0) {
        return new Localizable(holder, "Checks.Annotation.Message.SingleLine", arg0);
    }

    /**
     * Key {@code Column.CognitiveComplexity}: {@code Cognitive Complexity}.
     * 
     * @return
     *     {@code Cognitive Complexity}
     */
    public static String Column_CognitiveComplexity() {
        return holder.format("Column.CognitiveComplexity");
    }

    /**
     * Key {@code Column.CognitiveComplexity}: {@code Cognitive Complexity}.
     * 
     * @return
     *     {@code Cognitive Complexity}
     */
    public static Localizable _Column_CognitiveComplexity() {
        return new Localizable(holder, "Column.CognitiveComplexity");
    }

    /**
     * Key {@code Column.MaxComplexity}: {@code Max. Complexity}.
     * 
     * @return
     *     {@code Max. Complexity}
     */
    public static String Column_MaxComplexity() {
        return holder.format("Column.MaxComplexity");
    }

    /**
     * Key {@code Column.MaxComplexity}: {@code Max. Complexity}.
     * 
     * @return
     *     {@code Max. Complexity}
     */
    public static Localizable _Column_MaxComplexity() {
        return new Localizable(holder, "Column.MaxComplexity");
    }

    /**
     * Key {@code Column.DeltaLineCoverage}: {@code Line {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Line {0}}
     */
    public static String Column_DeltaLineCoverage(Object arg0) {
        return holder.format("Column.DeltaLineCoverage", arg0);
    }

    /**
     * Key {@code Column.DeltaLineCoverage}: {@code Line {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Line {0}}
     */
    public static Localizable _Column_DeltaLineCoverage(Object arg0) {
        return new Localizable(holder, "Column.DeltaLineCoverage", arg0);
    }

    /**
     * Key {@code Column.ComplexityDensity}: {@code Complexity / LOC}.
     * 
     * @return
     *     {@code Complexity / LOC}
     */
    public static String Column_ComplexityDensity() {
        return holder.format("Column.ComplexityDensity");
    }

    /**
     * Key {@code Column.ComplexityDensity}: {@code Complexity / LOC}.
     * 
     * @return
     *     {@code Complexity / LOC}
     */
    public static Localizable _Column_ComplexityDensity() {
        return new Localizable(holder, "Column.ComplexityDensity");
    }

    /**
     * Key {@code Coverage.Link.Name}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static String Coverage_Link_Name() {
        return holder.format("Coverage.Link.Name");
    }

    /**
     * Key {@code Coverage.Link.Name}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static Localizable _Coverage_Link_Name() {
        return new Localizable(holder, "Coverage.Link.Name");
    }

    /**
     * Key {@code Parser.Clover}: {@code Clover Coverage Reports}.
     * 
     * @return
     *     {@code Clover Coverage Reports}
     */
    public static String Parser_Clover() {
        return holder.format("Parser.Clover");
    }

    /**
     * Key {@code Parser.Clover}: {@code Clover Coverage Reports}.
     * 
     * @return
     *     {@code Clover Coverage Reports}
     */
    public static Localizable _Parser_Clover() {
        return new Localizable(holder, "Parser.Clover");
    }

    /**
     * Key {@code Coverage.Permission.Denied}: {@code You do not have

     * Jenkins' WORKSPACE permission to view the source code}.
     * 
     * @return
     *     {@code You do not have Jenkins' WORKSPACE permission to view the

     *     source code}
     */
    public static String Coverage_Permission_Denied() {
        return holder.format("Coverage.Permission.Denied");
    }

    /**
     * Key {@code Coverage.Permission.Denied}: {@code You do not have

     * Jenkins' WORKSPACE permission to view the source code}.
     * 
     * @return
     *     {@code You do not have Jenkins' WORKSPACE permission to view the

     *     source code}
     */
    public static Localizable _Coverage_Permission_Denied() {
        return new Localizable(holder, "Coverage.Permission.Denied");
    }

    /**
     * Key {@code Coverage.Trend.Name}: {@code {0} Trend}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} Trend}
     */
    public static String Coverage_Trend_Name(Object arg0) {
        return holder.format("Coverage.Trend.Name", arg0);
    }

    /**
     * Key {@code Coverage.Trend.Name}: {@code {0} Trend}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} Trend}
     */
    public static Localizable _Coverage_Trend_Name(Object arg0) {
        return new Localizable(holder, "Coverage.Trend.Name", arg0);
    }

    /**
     * Key {@code Column.DeltaMutationCoverage}: {@code Mutation {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mutation {0}}
     */
    public static String Column_DeltaMutationCoverage(Object arg0) {
        return holder.format("Column.DeltaMutationCoverage", arg0);
    }

    /**
     * Key {@code Column.DeltaMutationCoverage}: {@code Mutation {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mutation {0}}
     */
    public static Localizable _Column_DeltaMutationCoverage(Object arg0) {
        return new Localizable(holder, "Column.DeltaMutationCoverage", arg0);
    }

    /**
     * Key {@code Parser.Xunit}: {@code XUnit Test Results}.
     * 
     * @return
     *     {@code XUnit Test Results}
     */
    public static String Parser_Xunit() {
        return holder.format("Parser.Xunit");
    }

    /**
     * Key {@code Parser.Xunit}: {@code XUnit Test Results}.
     * 
     * @return
     *     {@code XUnit Test Results}
     */
    public static Localizable _Parser_Xunit() {
        return new Localizable(holder, "Parser.Xunit");
    }

    /**
     * Key {@code Parser.GoCov}: {@code Go Coverage Reports}.
     * 
     * @return
     *     {@code Go Coverage Reports}
     */
    public static String Parser_GoCov() {
        return holder.format("Parser.GoCov");
    }

    /**
     * Key {@code Parser.GoCov}: {@code Go Coverage Reports}.
     * 
     * @return
     *     {@code Go Coverage Reports}
     */
    public static Localizable _Parser_GoCov() {
        return new Localizable(holder, "Parser.GoCov");
    }

    /**
     * Key {@code Recorder.Name}: {@code Record code coverage results}.
     * 
     * @return
     *     {@code Record code coverage results}
     */
    public static String Recorder_Name() {
        return holder.format("Recorder.Name");
    }

    /**
     * Key {@code Recorder.Name}: {@code Record code coverage results}.
     * 
     * @return
     *     {@code Record code coverage results}
     */
    public static Localizable _Recorder_Name() {
        return new Localizable(holder, "Recorder.Name");
    }

    /**
     * Key {@code Indirect_Coverage_Changes_Type}: {@code Indirect Coverage

     * Changes}.
     * 
     * @return
     *     {@code Indirect Coverage Changes}
     */
    public static String Indirect_Coverage_Changes_Type() {
        return holder.format("Indirect_Coverage_Changes_Type");
    }

    /**
     * Key {@code Indirect_Coverage_Changes_Type}: {@code Indirect Coverage

     * Changes}.
     * 
     * @return
     *     {@code Indirect Coverage Changes}
     */
    public static Localizable _Indirect_Coverage_Changes_Type() {
        return new Localizable(holder, "Indirect_Coverage_Changes_Type");
    }

    /**
     * Key {@code Column.FunctionCall}: {@code Function Call}.
     * 
     * @return
     *     {@code Function Call}
     */
    public static String Column_FunctionCall() {
        return holder.format("Column.FunctionCall");
    }

    /**
     * Key {@code Column.FunctionCall}: {@code Function Call}.
     * 
     * @return
     *     {@code Function Call}
     */
    public static Localizable _Column_FunctionCall() {
        return new Localizable(holder, "Column.FunctionCall");
    }

    /**
     * Key {@code Column.File}: {@code File}.
     * 
     * @return
     *     {@code File}
     */
    public static String Column_File() {
        return holder.format("Column.File");
    }

    /**
     * Key {@code Column.File}: {@code File}.
     * 
     * @return
     *     {@code File}
     */
    public static Localizable _Column_File() {
        return new Localizable(holder, "Column.File");
    }

    /**
     * Key {@code Parser.OpenCover}: {@code OpenCover Coverage Reports}.
     * 
     * @return
     *     {@code OpenCover Coverage Reports}
     */
    public static String Parser_OpenCover() {
        return holder.format("Parser.OpenCover");
    }

    /**
     * Key {@code Parser.OpenCover}: {@code OpenCover Coverage Reports}.
     * 
     * @return
     *     {@code OpenCover Coverage Reports}
     */
    public static Localizable _Parser_OpenCover() {
        return new Localizable(holder, "Parser.OpenCover");
    }

    /**
     * Key {@code Column.LineCoverage}: {@code Line}.
     * 
     * @return
     *     {@code Line}
     */
    public static String Column_LineCoverage() {
        return holder.format("Column.LineCoverage");
    }

    /**
     * Key {@code Column.LineCoverage}: {@code Line}.
     * 
     * @return
     *     {@code Line}
     */
    public static Localizable _Column_LineCoverage() {
        return new Localizable(holder, "Column.LineCoverage");
    }

    /**
     * Key {@code Parser.Cobertura}: {@code Cobertura Coverage Reports}.
     * 
     * @return
     *     {@code Cobertura Coverage Reports}
     */
    public static String Parser_Cobertura() {
        return holder.format("Parser.Cobertura");
    }

    /**
     * Key {@code Parser.Cobertura}: {@code Cobertura Coverage Reports}.
     * 
     * @return
     *     {@code Cobertura Coverage Reports}
     */
    public static Localizable _Parser_Cobertura() {
        return new Localizable(holder, "Parser.Cobertura");
    }

    /**
     * Key {@code Column.Complexity}: {@code Complexity}.
     * 
     * @return
     *     {@code Complexity}
     */
    public static String Column_Complexity() {
        return holder.format("Column.Complexity");
    }

    /**
     * Key {@code Column.Complexity}: {@code Complexity}.
     * 
     * @return
     *     {@code Complexity}
     */
    public static Localizable _Column_Complexity() {
        return new Localizable(holder, "Column.Complexity");
    }

    /**
     * Key {@code Column.DeltaMCDCPairsCoverage}: {@code MCDCPairs {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code MCDCPairs {0}}
     */
    public static String Column_DeltaMCDCPairsCoverage(Object arg0) {
        return holder.format("Column.DeltaMCDCPairsCoverage", arg0);
    }

    /**
     * Key {@code Column.DeltaMCDCPairsCoverage}: {@code MCDCPairs {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code MCDCPairs {0}}
     */
    public static Localizable _Column_DeltaMCDCPairsCoverage(Object arg0) {
        return new Localizable(holder, "Column.DeltaMCDCPairsCoverage", arg0);
    }

}
