// CHECKSTYLE:OFF

package io.jenkins.plugins.coverage.metrics.source;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Coverage.Title}: {@code Coverage of ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage of ''{0}''}
     */
    public static String Coverage_Title(Object arg0) {
        return holder.format("Coverage.Title", arg0);
    }

    /**
     * Key {@code Coverage.Title}: {@code Coverage of ''{0}''}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage of ''{0}''}
     */
    public static Localizable _Coverage_Title(Object arg0) {
        return new Localizable(holder, "Coverage.Title", arg0);
    }

}
