// CHECKSTYLE:OFF

package io.jenkins.plugins.coverage.metrics.model;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Metric.Short.TEST_STRENGTH}: {@code Test Strength}.
     * 
     * @return
     *     {@code Test Strength}
     */
    public static String Metric_Short_TEST_STRENGTH() {
        return holder.format("Metric.Short.TEST_STRENGTH");
    }

    /**
     * Key {@code Metric.Short.TEST_STRENGTH}: {@code Test Strength}.
     * 
     * @return
     *     {@code Test Strength}
     */
    public static Localizable _Metric_Short_TEST_STRENGTH() {
        return new Localizable(holder, "Metric.Short.TEST_STRENGTH");
    }

    /**
     * Key {@code Metric.Short.MUTATION}: {@code Mutation}.
     * 
     * @return
     *     {@code Mutation}
     */
    public static String Metric_Short_MUTATION() {
        return holder.format("Metric.Short.MUTATION");
    }

    /**
     * Key {@code Metric.Short.MUTATION}: {@code Mutation}.
     * 
     * @return
     *     {@code Mutation}
     */
    public static Localizable _Metric_Short_MUTATION() {
        return new Localizable(holder, "Metric.Short.MUTATION");
    }

    /**
     * Key {@code Metric.COMPLEXITY_DENSITY}: {@code Complexity Density}.
     * 
     * @return
     *     {@code Complexity Density}
     */
    public static String Metric_COMPLEXITY_DENSITY() {
        return holder.format("Metric.COMPLEXITY_DENSITY");
    }

    /**
     * Key {@code Metric.COMPLEXITY_DENSITY}: {@code Complexity Density}.
     * 
     * @return
     *     {@code Complexity Density}
     */
    public static Localizable _Metric_COMPLEXITY_DENSITY() {
        return new Localizable(holder, "Metric.COMPLEXITY_DENSITY");
    }

    /**
     * Key {@code Metric.Short.METHOD}: {@code Method}.
     * 
     * @return
     *     {@code Method}
     */
    public static String Metric_Short_METHOD() {
        return holder.format("Metric.Short.METHOD");
    }

    /**
     * Key {@code Metric.Short.METHOD}: {@code Method}.
     * 
     * @return
     *     {@code Method}
     */
    public static Localizable _Metric_Short_METHOD() {
        return new Localizable(holder, "Metric.Short.METHOD");
    }

    /**
     * Key {@code Metric.METHOD}: {@code Method Coverage}.
     * 
     * @return
     *     {@code Method Coverage}
     */
    public static String Metric_METHOD() {
        return holder.format("Metric.METHOD");
    }

    /**
     * Key {@code Metric.METHOD}: {@code Method Coverage}.
     * 
     * @return
     *     {@code Method Coverage}
     */
    public static Localizable _Metric_METHOD() {
        return new Localizable(holder, "Metric.METHOD");
    }

    /**
     * Key {@code Metric.MCDC_PAIR}: {@code MC/DC Pair Coverage}.
     * 
     * @return
     *     {@code MC/DC Pair Coverage}
     */
    public static String Metric_MCDC_PAIR() {
        return holder.format("Metric.MCDC_PAIR");
    }

    /**
     * Key {@code Metric.MCDC_PAIR}: {@code MC/DC Pair Coverage}.
     * 
     * @return
     *     {@code MC/DC Pair Coverage}
     */
    public static Localizable _Metric_MCDC_PAIR() {
        return new Localizable(holder, "Metric.MCDC_PAIR");
    }

    /**
     * Key {@code Baseline.MODIFIED_LINES}: {@code Modified code lines}.
     * 
     * @return
     *     {@code Modified code lines}
     */
    public static String Baseline_MODIFIED_LINES() {
        return holder.format("Baseline.MODIFIED_LINES");
    }

    /**
     * Key {@code Baseline.MODIFIED_LINES}: {@code Modified code lines}.
     * 
     * @return
     *     {@code Modified code lines}
     */
    public static Localizable _Baseline_MODIFIED_LINES() {
        return new Localizable(holder, "Baseline.MODIFIED_LINES");
    }

    /**
     * Key {@code Metric.Short.FILE}: {@code File}.
     * 
     * @return
     *     {@code File}
     */
    public static String Metric_Short_FILE() {
        return holder.format("Metric.Short.FILE");
    }

    /**
     * Key {@code Metric.Short.FILE}: {@code File}.
     * 
     * @return
     *     {@code File}
     */
    public static Localizable _Metric_Short_FILE() {
        return new Localizable(holder, "Metric.Short.FILE");
    }

    /**
     * Key {@code Metric.Short.TESTS}: {@code Tests}.
     * 
     * @return
     *     {@code Tests}
     */
    public static String Metric_Short_TESTS() {
        return holder.format("Metric.Short.TESTS");
    }

    /**
     * Key {@code Metric.Short.TESTS}: {@code Tests}.
     * 
     * @return
     *     {@code Tests}
     */
    public static Localizable _Metric_Short_TESTS() {
        return new Localizable(holder, "Metric.Short.TESTS");
    }

    /**
     * Key {@code Metric.CLASS}: {@code Class Coverage}.
     * 
     * @return
     *     {@code Class Coverage}
     */
    public static String Metric_CLASS() {
        return holder.format("Metric.CLASS");
    }

    /**
     * Key {@code Metric.CLASS}: {@code Class Coverage}.
     * 
     * @return
     *     {@code Class Coverage}
     */
    public static Localizable _Metric_CLASS() {
        return new Localizable(holder, "Metric.CLASS");
    }

    /**
     * Key {@code Metric.BRANCH}: {@code Branch Coverage}.
     * 
     * @return
     *     {@code Branch Coverage}
     */
    public static String Metric_BRANCH() {
        return holder.format("Metric.BRANCH");
    }

    /**
     * Key {@code Metric.BRANCH}: {@code Branch Coverage}.
     * 
     * @return
     *     {@code Branch Coverage}
     */
    public static Localizable _Metric_BRANCH() {
        return new Localizable(holder, "Metric.BRANCH");
    }

    /**
     * Key {@code Metric.Short.COGNITIVE_COMPLEXITY}: {@code Cognitive

     * Complexity}.
     * 
     * @return
     *     {@code Cognitive Complexity}
     */
    public static String Metric_Short_COGNITIVE_COMPLEXITY() {
        return holder.format("Metric.Short.COGNITIVE_COMPLEXITY");
    }

    /**
     * Key {@code Metric.Short.COGNITIVE_COMPLEXITY}: {@code Cognitive

     * Complexity}.
     * 
     * @return
     *     {@code Cognitive Complexity}
     */
    public static Localizable _Metric_Short_COGNITIVE_COMPLEXITY() {
        return new Localizable(holder, "Metric.Short.COGNITIVE_COMPLEXITY");
    }

    /**
     * Key {@code Metric.CONTAINER}: {@code Container Coverage}.
     * 
     * @return
     *     {@code Container Coverage}
     */
    public static String Metric_CONTAINER() {
        return holder.format("Metric.CONTAINER");
    }

    /**
     * Key {@code Metric.CONTAINER}: {@code Container Coverage}.
     * 
     * @return
     *     {@code Container Coverage}
     */
    public static Localizable _Metric_CONTAINER() {
        return new Localizable(holder, "Metric.CONTAINER");
    }

    /**
     * Key {@code Metric.Coverage.Missed}: {@code Missed}.
     * 
     * @return
     *     {@code Missed}
     */
    public static String Metric_Coverage_Missed() {
        return holder.format("Metric.Coverage.Missed");
    }

    /**
     * Key {@code Metric.Coverage.Missed}: {@code Missed}.
     * 
     * @return
     *     {@code Missed}
     */
    public static Localizable _Metric_Coverage_Missed() {
        return new Localizable(holder, "Metric.Coverage.Missed");
    }

    /**
     * Key {@code Metric.Short.FUNCTION_CALL}: {@code Function Call}.
     * 
     * @return
     *     {@code Function Call}
     */
    public static String Metric_Short_FUNCTION_CALL() {
        return holder.format("Metric.Short.FUNCTION_CALL");
    }

    /**
     * Key {@code Metric.Short.FUNCTION_CALL}: {@code Function Call}.
     * 
     * @return
     *     {@code Function Call}
     */
    public static Localizable _Metric_Short_FUNCTION_CALL() {
        return new Localizable(holder, "Metric.Short.FUNCTION_CALL");
    }

    /**
     * Key {@code Metric.NCSS}: {@code NCSS}.
     * 
     * @return
     *     {@code NCSS}
     */
    public static String Metric_NCSS() {
        return holder.format("Metric.NCSS");
    }

    /**
     * Key {@code Metric.NCSS}: {@code NCSS}.
     * 
     * @return
     *     {@code NCSS}
     */
    public static Localizable _Metric_NCSS() {
        return new Localizable(holder, "Metric.NCSS");
    }

    /**
     * Key {@code Metric.COGNITIVE_COMPLEXITY}: {@code Cognitive Complexity}.
     * 
     * @return
     *     {@code Cognitive Complexity}
     */
    public static String Metric_COGNITIVE_COMPLEXITY() {
        return holder.format("Metric.COGNITIVE_COMPLEXITY");
    }

    /**
     * Key {@code Metric.COGNITIVE_COMPLEXITY}: {@code Cognitive Complexity}.
     * 
     * @return
     *     {@code Cognitive Complexity}
     */
    public static Localizable _Metric_COGNITIVE_COMPLEXITY() {
        return new Localizable(holder, "Metric.COGNITIVE_COMPLEXITY");
    }

    /**
     * Key {@code Baseline.MODIFIED_FILES_DELTA}: {@code Modified files

     * (difference to reference job)}.
     * 
     * @return
     *     {@code Modified files (difference to reference job)}
     */
    public static String Baseline_MODIFIED_FILES_DELTA() {
        return holder.format("Baseline.MODIFIED_FILES_DELTA");
    }

    /**
     * Key {@code Baseline.MODIFIED_FILES_DELTA}: {@code Modified files

     * (difference to reference job)}.
     * 
     * @return
     *     {@code Modified files (difference to reference job)}
     */
    public static Localizable _Baseline_MODIFIED_FILES_DELTA() {
        return new Localizable(holder, "Baseline.MODIFIED_FILES_DELTA");
    }

    /**
     * Key {@code Metric.Short.CONTAINER}: {@code Container}.
     * 
     * @return
     *     {@code Container}
     */
    public static String Metric_Short_CONTAINER() {
        return holder.format("Metric.Short.CONTAINER");
    }

    /**
     * Key {@code Metric.Short.CONTAINER}: {@code Container}.
     * 
     * @return
     *     {@code Container}
     */
    public static Localizable _Metric_Short_CONTAINER() {
        return new Localizable(holder, "Metric.Short.CONTAINER");
    }

    /**
     * Key {@code Metric.TEST_STRENGTH}: {@code Test Strength}.
     * 
     * @return
     *     {@code Test Strength}
     */
    public static String Metric_TEST_STRENGTH() {
        return holder.format("Metric.TEST_STRENGTH");
    }

    /**
     * Key {@code Metric.TEST_STRENGTH}: {@code Test Strength}.
     * 
     * @return
     *     {@code Test Strength}
     */
    public static Localizable _Metric_TEST_STRENGTH() {
        return new Localizable(holder, "Metric.TEST_STRENGTH");
    }

    /**
     * Key {@code Metric.Short.PACKAGE}: {@code Package}.
     * 
     * @return
     *     {@code Package}
     */
    public static String Metric_Short_PACKAGE() {
        return holder.format("Metric.Short.PACKAGE");
    }

    /**
     * Key {@code Metric.Short.PACKAGE}: {@code Package}.
     * 
     * @return
     *     {@code Package}
     */
    public static Localizable _Metric_Short_PACKAGE() {
        return new Localizable(holder, "Metric.Short.PACKAGE");
    }

    /**
     * Key {@code Metric.MUTATION.Killed}: {@code Killed}.
     * 
     * @return
     *     {@code Killed}
     */
    public static String Metric_MUTATION_Killed() {
        return holder.format("Metric.MUTATION.Killed");
    }

    /**
     * Key {@code Metric.MUTATION.Killed}: {@code Killed}.
     * 
     * @return
     *     {@code Killed}
     */
    public static Localizable _Metric_MUTATION_Killed() {
        return new Localizable(holder, "Metric.MUTATION.Killed");
    }

    /**
     * Key {@code Metric.MUTATION.Survived}: {@code Survived}.
     * 
     * @return
     *     {@code Survived}
     */
    public static String Metric_MUTATION_Survived() {
        return holder.format("Metric.MUTATION.Survived");
    }

    /**
     * Key {@code Metric.MUTATION.Survived}: {@code Survived}.
     * 
     * @return
     *     {@code Survived}
     */
    public static Localizable _Metric_MUTATION_Survived() {
        return new Localizable(holder, "Metric.MUTATION.Survived");
    }

    /**
     * Key {@code Baseline.PROJECT_DELTA}: {@code Overall project (difference

     * to reference job)}.
     * 
     * @return
     *     {@code Overall project (difference to reference job)}
     */
    public static String Baseline_PROJECT_DELTA() {
        return holder.format("Baseline.PROJECT_DELTA");
    }

    /**
     * Key {@code Baseline.PROJECT_DELTA}: {@code Overall project (difference

     * to reference job)}.
     * 
     * @return
     *     {@code Overall project (difference to reference job)}
     */
    public static Localizable _Baseline_PROJECT_DELTA() {
        return new Localizable(holder, "Baseline.PROJECT_DELTA");
    }

    /**
     * Key {@code Metric.Short.NPATH}: {@code NPath Complexity}.
     * 
     * @return
     *     {@code NPath Complexity}
     */
    public static String Metric_Short_NPATH() {
        return holder.format("Metric.Short.NPATH");
    }

    /**
     * Key {@code Metric.Short.NPATH}: {@code NPath Complexity}.
     * 
     * @return
     *     {@code NPath Complexity}
     */
    public static Localizable _Metric_Short_NPATH() {
        return new Localizable(holder, "Metric.Short.NPATH");
    }

    /**
     * Key {@code Metric.COMPLEXITY_MAXIMUM}: {@code Maximum Cyclomatic

     * Complexity}.
     * 
     * @return
     *     {@code Maximum Cyclomatic Complexity}
     */
    public static String Metric_COMPLEXITY_MAXIMUM() {
        return holder.format("Metric.COMPLEXITY_MAXIMUM");
    }

    /**
     * Key {@code Metric.COMPLEXITY_MAXIMUM}: {@code Maximum Cyclomatic

     * Complexity}.
     * 
     * @return
     *     {@code Maximum Cyclomatic Complexity}
     */
    public static Localizable _Metric_COMPLEXITY_MAXIMUM() {
        return new Localizable(holder, "Metric.COMPLEXITY_MAXIMUM");
    }

    /**
     * Key {@code Metric.Short.INSTRUCTION}: {@code Instruction}.
     * 
     * @return
     *     {@code Instruction}
     */
    public static String Metric_Short_INSTRUCTION() {
        return holder.format("Metric.Short.INSTRUCTION");
    }

    /**
     * Key {@code Metric.Short.INSTRUCTION}: {@code Instruction}.
     * 
     * @return
     *     {@code Instruction}
     */
    public static Localizable _Metric_Short_INSTRUCTION() {
        return new Localizable(holder, "Metric.Short.INSTRUCTION");
    }

    /**
     * Key {@code Metric.Short.LOC}: {@code LOC}.
     * 
     * @return
     *     {@code LOC}
     */
    public static String Metric_Short_LOC() {
        return holder.format("Metric.Short.LOC");
    }

    /**
     * Key {@code Metric.Short.LOC}: {@code LOC}.
     * 
     * @return
     *     {@code LOC}
     */
    public static Localizable _Metric_Short_LOC() {
        return new Localizable(holder, "Metric.Short.LOC");
    }

    /**
     * Key {@code Metric.Short.COMPLEXITY}: {@code Complexity}.
     * 
     * @return
     *     {@code Complexity}
     */
    public static String Metric_Short_COMPLEXITY() {
        return holder.format("Metric.Short.COMPLEXITY");
    }

    /**
     * Key {@code Metric.Short.COMPLEXITY}: {@code Complexity}.
     * 
     * @return
     *     {@code Complexity}
     */
    public static Localizable _Metric_Short_COMPLEXITY() {
        return new Localizable(holder, "Metric.Short.COMPLEXITY");
    }

    /**
     * Key {@code Metric.Short.MODULE}: {@code Module}.
     * 
     * @return
     *     {@code Module}
     */
    public static String Metric_Short_MODULE() {
        return holder.format("Metric.Short.MODULE");
    }

    /**
     * Key {@code Metric.Short.MODULE}: {@code Module}.
     * 
     * @return
     *     {@code Module}
     */
    public static Localizable _Metric_Short_MODULE() {
        return new Localizable(holder, "Metric.Short.MODULE");
    }

    /**
     * Key {@code Metric.MUTATION}: {@code Mutation Coverage}.
     * 
     * @return
     *     {@code Mutation Coverage}
     */
    public static String Metric_MUTATION() {
        return holder.format("Metric.MUTATION");
    }

    /**
     * Key {@code Metric.MUTATION}: {@code Mutation Coverage}.
     * 
     * @return
     *     {@code Mutation Coverage}
     */
    public static Localizable _Metric_MUTATION() {
        return new Localizable(holder, "Metric.MUTATION");
    }

    /**
     * Key {@code Baseline.PROJECT}: {@code Overall project}.
     * 
     * @return
     *     {@code Overall project}
     */
    public static String Baseline_PROJECT() {
        return holder.format("Baseline.PROJECT");
    }

    /**
     * Key {@code Baseline.PROJECT}: {@code Overall project}.
     * 
     * @return
     *     {@code Overall project}
     */
    public static Localizable _Baseline_PROJECT() {
        return new Localizable(holder, "Baseline.PROJECT");
    }

    /**
     * Key {@code Metric.Short.COMPLEXITY_MAXIMUM}: {@code Max. Complexity}.
     * 
     * @return
     *     {@code Max. Complexity}
     */
    public static String Metric_Short_COMPLEXITY_MAXIMUM() {
        return holder.format("Metric.Short.COMPLEXITY_MAXIMUM");
    }

    /**
     * Key {@code Metric.Short.COMPLEXITY_MAXIMUM}: {@code Max. Complexity}.
     * 
     * @return
     *     {@code Max. Complexity}
     */
    public static Localizable _Metric_Short_COMPLEXITY_MAXIMUM() {
        return new Localizable(holder, "Metric.Short.COMPLEXITY_MAXIMUM");
    }

    /**
     * Key {@code Baseline.MODIFIED_FILES}: {@code Modified files}.
     * 
     * @return
     *     {@code Modified files}
     */
    public static String Baseline_MODIFIED_FILES() {
        return holder.format("Baseline.MODIFIED_FILES");
    }

    /**
     * Key {@code Baseline.MODIFIED_FILES}: {@code Modified files}.
     * 
     * @return
     *     {@code Modified files}
     */
    public static Localizable _Baseline_MODIFIED_FILES() {
        return new Localizable(holder, "Baseline.MODIFIED_FILES");
    }

    /**
     * Key {@code Metric.Short.NCSS}: {@code NCSS}.
     * 
     * @return
     *     {@code NCSS}
     */
    public static String Metric_Short_NCSS() {
        return holder.format("Metric.Short.NCSS");
    }

    /**
     * Key {@code Metric.Short.NCSS}: {@code NCSS}.
     * 
     * @return
     *     {@code NCSS}
     */
    public static Localizable _Metric_Short_NCSS() {
        return new Localizable(holder, "Metric.Short.NCSS");
    }

    /**
     * Key {@code Metric.LINE}: {@code Line Coverage}.
     * 
     * @return
     *     {@code Line Coverage}
     */
    public static String Metric_LINE() {
        return holder.format("Metric.LINE");
    }

    /**
     * Key {@code Metric.LINE}: {@code Line Coverage}.
     * 
     * @return
     *     {@code Line Coverage}
     */
    public static Localizable _Metric_LINE() {
        return new Localizable(holder, "Metric.LINE");
    }

    /**
     * Key {@code Metric.FUNCTION_CALL}: {@code Function Call Coverage}.
     * 
     * @return
     *     {@code Function Call Coverage}
     */
    public static String Metric_FUNCTION_CALL() {
        return holder.format("Metric.FUNCTION_CALL");
    }

    /**
     * Key {@code Metric.FUNCTION_CALL}: {@code Function Call Coverage}.
     * 
     * @return
     *     {@code Function Call Coverage}
     */
    public static Localizable _Metric_FUNCTION_CALL() {
        return new Localizable(holder, "Metric.FUNCTION_CALL");
    }

    /**
     * Key {@code Metric.FILE}: {@code File Coverage}.
     * 
     * @return
     *     {@code File Coverage}
     */
    public static String Metric_FILE() {
        return holder.format("Metric.FILE");
    }

    /**
     * Key {@code Metric.FILE}: {@code File Coverage}.
     * 
     * @return
     *     {@code File Coverage}
     */
    public static Localizable _Metric_FILE() {
        return new Localizable(holder, "Metric.FILE");
    }

    /**
     * Key {@code Metric.Short.MCDC_PAIR}: {@code MC/DC Pair}.
     * 
     * @return
     *     {@code MC/DC Pair}
     */
    public static String Metric_Short_MCDC_PAIR() {
        return holder.format("Metric.Short.MCDC_PAIR");
    }

    /**
     * Key {@code Metric.Short.MCDC_PAIR}: {@code MC/DC Pair}.
     * 
     * @return
     *     {@code MC/DC Pair}
     */
    public static Localizable _Metric_Short_MCDC_PAIR() {
        return new Localizable(holder, "Metric.Short.MCDC_PAIR");
    }

    /**
     * Key {@code Metric.Coverage.Covered}: {@code Covered}.
     * 
     * @return
     *     {@code Covered}
     */
    public static String Metric_Coverage_Covered() {
        return holder.format("Metric.Coverage.Covered");
    }

    /**
     * Key {@code Metric.Coverage.Covered}: {@code Covered}.
     * 
     * @return
     *     {@code Covered}
     */
    public static Localizable _Metric_Coverage_Covered() {
        return new Localizable(holder, "Metric.Coverage.Covered");
    }

    /**
     * Key {@code Metric.Short.BRANCH}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static String Metric_Short_BRANCH() {
        return holder.format("Metric.Short.BRANCH");
    }

    /**
     * Key {@code Metric.Short.BRANCH}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static Localizable _Metric_Short_BRANCH() {
        return new Localizable(holder, "Metric.Short.BRANCH");
    }

    /**
     * Key {@code Metric.LOC}: {@code Lines of Code}.
     * 
     * @return
     *     {@code Lines of Code}
     */
    public static String Metric_LOC() {
        return holder.format("Metric.LOC");
    }

    /**
     * Key {@code Metric.LOC}: {@code Lines of Code}.
     * 
     * @return
     *     {@code Lines of Code}
     */
    public static Localizable _Metric_LOC() {
        return new Localizable(holder, "Metric.LOC");
    }

    /**
     * Key {@code Metric.COMPLEXITY}: {@code Cyclomatic Complexity}.
     * 
     * @return
     *     {@code Cyclomatic Complexity}
     */
    public static String Metric_COMPLEXITY() {
        return holder.format("Metric.COMPLEXITY");
    }

    /**
     * Key {@code Metric.COMPLEXITY}: {@code Cyclomatic Complexity}.
     * 
     * @return
     *     {@code Cyclomatic Complexity}
     */
    public static Localizable _Metric_COMPLEXITY() {
        return new Localizable(holder, "Metric.COMPLEXITY");
    }

    /**
     * Key {@code Baseline.MODIFIED_LINES_DELTA}: {@code Modified code lines

     * (difference to modified files)}.
     * 
     * @return
     *     {@code Modified code lines (difference to modified files)}
     */
    public static String Baseline_MODIFIED_LINES_DELTA() {
        return holder.format("Baseline.MODIFIED_LINES_DELTA");
    }

    /**
     * Key {@code Baseline.MODIFIED_LINES_DELTA}: {@code Modified code lines

     * (difference to modified files)}.
     * 
     * @return
     *     {@code Modified code lines (difference to modified files)}
     */
    public static Localizable _Baseline_MODIFIED_LINES_DELTA() {
        return new Localizable(holder, "Baseline.MODIFIED_LINES_DELTA");
    }

    /**
     * Key {@code Metric.INSTRUCTION}: {@code Instruction Coverage}.
     * 
     * @return
     *     {@code Instruction Coverage}
     */
    public static String Metric_INSTRUCTION() {
        return holder.format("Metric.INSTRUCTION");
    }

    /**
     * Key {@code Metric.INSTRUCTION}: {@code Instruction Coverage}.
     * 
     * @return
     *     {@code Instruction Coverage}
     */
    public static Localizable _Metric_INSTRUCTION() {
        return new Localizable(holder, "Metric.INSTRUCTION");
    }

    /**
     * Key {@code Metric.Short.LINE}: {@code Line}.
     * 
     * @return
     *     {@code Line}
     */
    public static String Metric_Short_LINE() {
        return holder.format("Metric.Short.LINE");
    }

    /**
     * Key {@code Metric.Short.LINE}: {@code Line}.
     * 
     * @return
     *     {@code Line}
     */
    public static Localizable _Metric_Short_LINE() {
        return new Localizable(holder, "Metric.Short.LINE");
    }

    /**
     * Key {@code Metric.NPATH}: {@code NPath Complexity}.
     * 
     * @return
     *     {@code NPath Complexity}
     */
    public static String Metric_NPATH() {
        return holder.format("Metric.NPATH");
    }

    /**
     * Key {@code Metric.NPATH}: {@code NPath Complexity}.
     * 
     * @return
     *     {@code NPath Complexity}
     */
    public static Localizable _Metric_NPATH() {
        return new Localizable(holder, "Metric.NPATH");
    }

    /**
     * Key {@code Metric.Short.COMPLEXITY_DENSITY}: {@code Complexity

     * Density}.
     * 
     * @return
     *     {@code Complexity Density}
     */
    public static String Metric_Short_COMPLEXITY_DENSITY() {
        return holder.format("Metric.Short.COMPLEXITY_DENSITY");
    }

    /**
     * Key {@code Metric.Short.COMPLEXITY_DENSITY}: {@code Complexity

     * Density}.
     * 
     * @return
     *     {@code Complexity Density}
     */
    public static Localizable _Metric_Short_COMPLEXITY_DENSITY() {
        return new Localizable(holder, "Metric.Short.COMPLEXITY_DENSITY");
    }

    /**
     * Key {@code Baseline.INDIRECT}: {@code Indirect changes}.
     * 
     * @return
     *     {@code Indirect changes}
     */
    public static String Baseline_INDIRECT() {
        return holder.format("Baseline.INDIRECT");
    }

    /**
     * Key {@code Baseline.INDIRECT}: {@code Indirect changes}.
     * 
     * @return
     *     {@code Indirect changes}
     */
    public static Localizable _Baseline_INDIRECT() {
        return new Localizable(holder, "Baseline.INDIRECT");
    }

    /**
     * Key {@code Metric.TESTS}: {@code Test Cases}.
     * 
     * @return
     *     {@code Test Cases}
     */
    public static String Metric_TESTS() {
        return holder.format("Metric.TESTS");
    }

    /**
     * Key {@code Metric.TESTS}: {@code Test Cases}.
     * 
     * @return
     *     {@code Test Cases}
     */
    public static Localizable _Metric_TESTS() {
        return new Localizable(holder, "Metric.TESTS");
    }

    /**
     * Key {@code Metric.PACKAGE}: {@code Package Coverage}.
     * 
     * @return
     *     {@code Package Coverage}
     */
    public static String Metric_PACKAGE() {
        return holder.format("Metric.PACKAGE");
    }

    /**
     * Key {@code Metric.PACKAGE}: {@code Package Coverage}.
     * 
     * @return
     *     {@code Package Coverage}
     */
    public static Localizable _Metric_PACKAGE() {
        return new Localizable(holder, "Metric.PACKAGE");
    }

    /**
     * Key {@code Metric.MODULE}: {@code Module Coverage}.
     * 
     * @return
     *     {@code Module Coverage}
     */
    public static String Metric_MODULE() {
        return holder.format("Metric.MODULE");
    }

    /**
     * Key {@code Metric.MODULE}: {@code Module Coverage}.
     * 
     * @return
     *     {@code Module Coverage}
     */
    public static Localizable _Metric_MODULE() {
        return new Localizable(holder, "Metric.MODULE");
    }

    /**
     * Key {@code Metric.Short.CLASS}: {@code Class}.
     * 
     * @return
     *     {@code Class}
     */
    public static String Metric_Short_CLASS() {
        return holder.format("Metric.Short.CLASS");
    }

    /**
     * Key {@code Metric.Short.CLASS}: {@code Class}.
     * 
     * @return
     *     {@code Class}
     */
    public static Localizable _Metric_Short_CLASS() {
        return new Localizable(holder, "Metric.Short.CLASS");
    }

}
