/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class NoClientBindSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final NoClientBindSSLProtocolSocketFactory factory = new NoClientBindSSLProtocolSocketFactory();

    static NoClientBindSSLProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        return this.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return this.createSocket(host, port);
        }
        Socket socket = ReflectionSocketFactory.createSocket((String)"javax.net.ssl.SSLSocketFactory", (String)host, (int)port, null, (int)0, (int)timeout);
        if (socket == null) {
            socket = ControllerThreadSocketFactory.createSocket((ProtocolSocketFactory)this, (String)host, (int)port, null, (int)0, (int)timeout);
        }
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException {
        return SSLSocketFactory.getDefault().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(SSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return SSLProtocolSocketFactory.class.hashCode();
    }
}

