/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.codebuildcloud;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import hudson.Extension;
import hudson.model.Computer;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import inet.ipaddr.IPAddressString;
import io.jenkins.plugins.codebuildcloud.CodeBuildComputer;
import io.jenkins.plugins.codebuildcloud.CodeBuildLauncher;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.slaves.DefaultJnlpSlaveReceiver;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;

@Extension(ordinal=10.0)
public class CodeBuildJnlpAgentReceiver
extends DefaultJnlpSlaveReceiver {
    private static final Logger LOGGER = Logger.getLogger(CodeBuildComputer.class.getName());
    private static transient List<IPAddressString> allowedIPs = new ArrayList<IPAddressString>();
    private static transient int DEFAULT_CACHE_TIME_FOR_AWS_IPS = 24;
    private static transient Cache<String, String> myIPCache = Caffeine.newBuilder().expireAfterWrite((long)DEFAULT_CACHE_TIME_FOR_AWS_IPS, TimeUnit.HOURS).build();

    private static String getAmazonIPInfo() {
        LOGGER.finest("getAmazonIPInfo BEGIN");
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(10L)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://ip-ranges.amazonaws.com/ip-ranges.json")).build();
        try {
            HttpResponse<String> resp = client.send(request, HttpResponse.BodyHandlers.ofString());
            assert (resp.statusCode() == 200);
            LOGGER.finest("getAmazonIPInfo END");
            return resp.body();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.finest("getAmazonIPInfo END FAIL");
            return null;
        }
    }

    private static void parseAmazonResponse(Map<String, List<String>> map, String key, JSONArray jsonArray) {
        for (Object ob : jsonArray) {
            JSONObject inner = JSONObject.fromObject(ob);
            String cidr = inner.get(key).toString();
            String service = inner.get("service").toString();
            if (service.equals("AMAZON") || service.equals("CODEBUILD")) {
                map.get("CODEBUILD").add(cidr);
                continue;
            }
            if (!service.equals("EC2")) continue;
            map.get("EC2").add(cidr);
        }
    }

    private static synchronized void refreshCache() {
        String body = (String)myIPCache.get((Object)"AWSIPS", a -> CodeBuildJnlpAgentReceiver.getAmazonIPInfo());
        allowedIPs = new ArrayList<IPAddressString>();
        if (body == null) {
            return;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("EC2", new ArrayList());
        map.put("CODEBUILD", new ArrayList());
        JSONObject json = JSONObject.fromObject((Object)body);
        CodeBuildJnlpAgentReceiver.parseAmazonResponse(map, "ip_prefix", json.getJSONArray("prefixes"));
        CodeBuildJnlpAgentReceiver.parseAmazonResponse(map, "ipv6_prefix", json.getJSONArray("ipv6_prefixes"));
        ArrayList<IPAddressString> final_list = new ArrayList<IPAddressString>();
        for (String ip : (List)map.get("CODEBUILD")) {
            if (((List)map.get("EC2")).contains(ip)) continue;
            final_list.add(new IPAddressString(ip));
        }
        LOGGER.info("Allowed AWS CodeBuild IPs Length refresh: " + final_list.size());
        allowedIPs = final_list;
    }

    public boolean owns(String clientName) {
        Computer computer = Jenkins.get().getComputer(clientName);
        return computer != null && computer instanceof CodeBuildComputer;
    }

    public void afterProperties(JnlpConnectionState event) {
        String clientName = event.getProperty("Node-Name");
        SlaveComputer computer = (SlaveComputer)Jenkins.get().getComputer(clientName);
        if (computer == null) {
            super.afterProperties(event);
            return;
        }
        ComputerLauncher launcher = computer.getLauncher();
        if (!(launcher instanceof CodeBuildLauncher)) {
            super.afterProperties(event);
            return;
        }
        CodeBuildLauncher ourLauncher = (CodeBuildLauncher)launcher;
        if (!ourLauncher.cloud.getVerifyIsCodeBuildIPOnJNLP().booleanValue()) {
            super.afterProperties(event);
            return;
        }
        CodeBuildJnlpAgentReceiver.refreshCache();
        IPAddressString agentRequestIP = new IPAddressString(event.getSocket().getInetAddress().getHostAddress());
        boolean valid_ip = false;
        for (IPAddressString amazoncidr : allowedIPs) {
            if (!amazoncidr.contains(agentRequestIP)) continue;
            valid_ip = true;
            break;
        }
        LOGGER.finest("Is Valid IP: " + valid_ip);
        if (valid_ip) {
            super.afterProperties(event);
        } else {
            event.reject(new ConnectionRefusalException("Invalid Source IP, was not from AWS CodeBuild"));
        }
    }

    public void channelClosed(JnlpConnectionState event) {
    }
}

