/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.codebuildcloud;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.codebuild.AWSCodeBuild;
import com.amazonaws.services.codebuild.AWSCodeBuildClientBuilder;
import com.amazonaws.services.codebuild.model.BatchGetBuildsRequest;
import com.amazonaws.services.codebuild.model.BatchGetBuildsResult;
import com.amazonaws.services.codebuild.model.BatchGetProjectsRequest;
import com.amazonaws.services.codebuild.model.BatchGetProjectsResult;
import com.amazonaws.services.codebuild.model.Build;
import com.amazonaws.services.codebuild.model.ListProjectsRequest;
import com.amazonaws.services.codebuild.model.ListProjectsResult;
import com.amazonaws.services.codebuild.model.Project;
import com.amazonaws.services.codebuild.model.StartBuildRequest;
import com.amazonaws.services.codebuild.model.StartBuildResult;
import com.amazonaws.services.codebuild.model.StopBuildRequest;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import java.io.InvalidObjectException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class CodeBuildClientWrapper {
    private AWSCodeBuild _client;
    private static final Logger LOGGER = Logger.getLogger(CodeBuildClientWrapper.class.getName());
    private static transient Cache<String, Integer> myCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    public CodeBuildClientWrapper(String credentialsId, String region, Jenkins instance) {
        this._client = CodeBuildClientWrapper.buildClient(credentialsId, region, instance);
    }

    private static AWSCodeBuild buildClient(String credentialsId, String region, Jenkins instance) {
        ProxyConfiguration proxy = instance.proxy;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (proxy != null) {
            clientConfiguration.setProxyHost(proxy.name);
            clientConfiguration.setProxyPort(proxy.port);
            clientConfiguration.setProxyUsername(proxy.getUserName());
            clientConfiguration.setProxyPassword(proxy.getPassword());
        }
        AWSCodeBuildClientBuilder builder = (AWSCodeBuildClientBuilder)((AWSCodeBuildClientBuilder)AWSCodeBuildClientBuilder.standard().withClientConfiguration(clientConfiguration)).withRegion(region);
        AmazonWebServicesCredentials credentials = AWSCredentialsHelper.getCredentials((String)credentialsId, (ItemGroup)instance);
        if (credentials != null) {
            String awsAccessKeyId = credentials.getCredentials().getAWSAccessKeyId();
            LOGGER.finest("Using credentials:" + awsAccessKeyId);
            builder.withCredentials((AWSCredentialsProvider)credentials);
        }
        LOGGER.log(Level.FINEST, "Selected Region: " + region);
        return (AWSCodeBuild)builder.build();
    }

    public ListProjectsResult listProjects(ListProjectsRequest request) {
        return this._client.listProjects(request);
    }

    public CodeBuildStatus getBuildStatus(@NonNull String buildId) {
        BatchGetBuildsRequest req = new BatchGetBuildsRequest();
        req.setIds(Arrays.asList(buildId));
        BatchGetBuildsResult res = this._client.batchGetBuilds(req);
        assert (res.getBuilds().size() == 1);
        Build b = (Build)res.getBuilds().get(0);
        String bstatus = b.getBuildStatus();
        return CodeBuildStatus.valueOf(bstatus);
    }

    public void checkBuildStatus(@NonNull String buildId, List<CodeBuildStatus> invalidStatuses) throws InvalidObjectException {
        CodeBuildStatus status = this.getBuildStatus(buildId);
        LOGGER.finest("Current Build Status: buildId - " + buildId + " Status: " + status.name());
        if (invalidStatuses.contains((Object)status)) {
            throw new InvalidObjectException("Invalid CodeBuild status detected");
        }
    }

    public StartBuildResult startBuild(StartBuildRequest req) {
        return this._client.startBuild(req);
    }

    public void stopBuild(@NonNull String buildId) {
        LOGGER.finest(String.format("Stop Build Requested for build ID: %s", buildId));
        CodeBuildStatus status = this.getBuildStatus(buildId);
        if (status == CodeBuildStatus.IN_PROGRESS) {
            try {
                LOGGER.finest(String.format("Stopping build ID: %s", buildId));
                this._client.stopBuild(new StopBuildRequest().withId(buildId));
            }
            catch (Exception e) {
                LOGGER.severe(String.format("Exception while attempting to stop build: %s.  Exception %s", e.getMessage(), e));
            }
        } else {
            LOGGER.finest(String.format("Build ID: %s already stopped", buildId));
        }
    }

    private Integer _getMaxConcurrentJobs(@NonNull String jobName) {
        Integer result = Integer.MAX_VALUE;
        try {
            BatchGetProjectsResult res = this._client.batchGetProjects(new BatchGetProjectsRequest().withNames(new String[]{jobName}));
            assert (res.getProjects().size() == 1);
            Project myproj = (Project)res.getProjects().get(0);
            if (myproj.getConcurrentBuildLimit() != null) {
                result = myproj.getConcurrentBuildLimit();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to determine codebuild project size", e);
        }
        LOGGER.finest("Total possible concurrent jobs  is being set to " + result);
        return result;
    }

    public Integer getMaxConcurrentJobs(@NonNull String jobName) {
        return (Integer)myCache.get((Object)jobName, j -> this._getMaxConcurrentJobs((String)j));
    }

    public static enum CodeBuildStatus {
        FAILED,
        FAULT,
        IN_PROGRESS,
        STOPPED,
        SUCCEEDED,
        TIMED_OUT;

    }
}

