/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.codebuildcloud;

import com.amazonaws.services.codebuild.model.EnvironmentVariable;
import com.amazonaws.services.codebuild.model.SourceType;
import com.amazonaws.services.codebuild.model.StartBuildRequest;
import com.amazonaws.services.codebuild.model.StartBuildResult;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import io.jenkins.plugins.codebuildcloud.CodeBuildAgent;
import io.jenkins.plugins.codebuildcloud.CodeBuildClientWrapper;
import io.jenkins.plugins.codebuildcloud.CodeBuildCloud;
import io.jenkins.plugins.codebuildcloud.CodeBuildComputer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;

public class CodeBuildLauncher
extends JNLPLauncher {
    private static final int sleepMs = 500;
    private static final Logger LOGGER = Logger.getLogger(CodeBuildLauncher.class.getName());
    private static final int CHECK_WITH_CODEBUILD_STATUS = Math.multiplyExact(30, 1000);
    public final CodeBuildCloud cloud;
    private boolean launched = false;

    public CodeBuildLauncher(CodeBuildCloud cloud) {
        super(true);
        this.cloud = cloud;
    }

    public boolean isLaunchSupported() {
        return !this.launched;
    }

    public void launch(@NonNull SlaveComputer computer, @NonNull TaskListener listener) {
        this.launched = false;
        if (!(computer instanceof CodeBuildComputer)) {
            LOGGER.finest(String.format("Not launching %s since it is not the correct type (%s)", computer, CodeBuildComputer.class.getName()));
            return;
        }
        CodeBuildComputer codebuildComputer = (CodeBuildComputer)computer;
        CodeBuildAgent node = (CodeBuildAgent)codebuildComputer.getNode();
        if (node == null) {
            LOGGER.severe(String.format("Not launching %s since it is missing a node.", computer.getName()));
            return;
        }
        LOGGER.info(String.format("Launching %s with %s", computer, listener));
        List<EnvironmentVariable> myenvcollection = this.buildEnvVariableCollection(computer, (Node)node);
        StartBuildRequest req = new StartBuildRequest().withProjectName(this.cloud.getCodeBuildProjectName()).withSourceTypeOverride(SourceType.NO_SOURCE).withImageOverride(this.cloud.getDockerImage()).withEnvironmentTypeOverride(this.cloud.getEnvironmentType()).withPrivilegedModeOverride(Boolean.valueOf(true)).withEnvironmentVariablesOverride(myenvcollection).withComputeTypeOverride(this.cloud.getComputeType()).withImagePullCredentialsTypeOverride(this.cloud.getDockerImagePullCredentials()).withBuildspecOverride(this.cloud.getBuildSpec());
        String buildId = null;
        try {
            StartBuildResult res = this.cloud.getClient().startBuild(req);
            buildId = res.getBuild().getId();
            codebuildComputer.setBuildId(buildId);
            this.waitForAgentConnection(computer, buildId, (Node)node);
            this.launched = true;
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Exception while starting build: %s.  Exception %s", e.getMessage(), e));
            listener.fatalError("Exception while starting build: %s", new Object[]{e.getMessage()});
            try {
                node.terminate();
            }
            catch (IOException | InterruptedException e1) {
                LOGGER.severe(String.format("Failed to terminate agent: %s.  Exception: %s", node.getDisplayName(), e));
            }
        }
    }

    private void waitForAgentConnection(@NonNull SlaveComputer computer, @NonNull String buildId, @NonNull Node node) throws TimeoutException, InvalidObjectException, InterruptedException {
        LOGGER.info(String.format("Waiting for agent '%s' to connect with build ID: %s...", computer, buildId));
        int checkbuildcounter = 0;
        for (int i = 0; i < this.cloud.getAgentConnectTimeout() * 2; ++i) {
            if (computer.isOnline() && computer.isAcceptingTasks()) {
                LOGGER.info(String.format(" Agent '%s' connected to build ID: %s.", computer, buildId));
                return;
            }
            Thread.sleep(500L);
            if ((checkbuildcounter += 500) <= 30000) continue;
            checkbuildcounter = 0;
            this.cloud.getClient().checkBuildStatus(buildId, Arrays.asList(CodeBuildClientWrapper.CodeBuildStatus.FAILED, CodeBuildClientWrapper.CodeBuildStatus.FAULT, CodeBuildClientWrapper.CodeBuildStatus.STOPPED, CodeBuildClientWrapper.CodeBuildStatus.SUCCEEDED, CodeBuildClientWrapper.CodeBuildStatus.TIMED_OUT));
        }
        throw new TimeoutException("Timed out while waiting for agent " + String.valueOf(node) + " to start for build ID: " + buildId);
    }

    private String lookupProxyCredentials() {
        String proxyCredentialId = this.cloud.getProxyCredentialsId();
        String proxyCredentials = null;
        if (!StringUtils.isBlank((CharSequence)proxyCredentialId)) {
            CodeBuildLauncher codeBuildLauncher = this;
            List creds = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)codeBuildLauncher.cloud.getJenkins(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST);
            Credentials c = CredentialsMatchers.firstOrNull((Iterable)creds, (CredentialsMatcher)CredentialsMatchers.withId((String)proxyCredentialId));
            if (c != null) {
                StandardUsernamePasswordCredentials mycreds = (StandardUsernamePasswordCredentials)c;
                proxyCredentials = mycreds.getUsername() + ":" + mycreds.getPassword().getPlainText();
            }
        }
        return proxyCredentials;
    }

    private List<EnvironmentVariable> buildEnvVariableCollection(@NonNull SlaveComputer computer, @NonNull Node node) {
        ArrayList<EnvironmentVariable> mylist = new ArrayList<EnvironmentVariable>();
        String proxyCredentials = this.lookupProxyCredentials();
        if (StringUtils.isNotEmpty((CharSequence)this.cloud.getDirect())) {
            mylist.add(this.createEnvVariable("JENKINS_DIRECT_CONNECTION", this.cloud.getDirect()));
            mylist.add(this.createEnvVariable("JENKINS_INSTANCE_IDENTITY", this.cloud.getControllerIdentity().getPlainText()));
            if (StringUtils.isNotEmpty((CharSequence)this.cloud.getProtocols())) {
                mylist.add(this.createEnvVariable("JENKINS_PROTOCOLS", this.cloud.getProtocols()));
            }
            if (StringUtils.isNotEmpty((CharSequence)proxyCredentials)) {
                mylist.add(this.createEnvVariable("JENKINS_CODEBUILD_PROXY_CREDENTIALS", "-proxyCredentials " + proxyCredentials));
            }
            if (this.cloud.getNoKeepAlive().booleanValue()) {
                mylist.add(this.createEnvVariable("JENKINS_CODEBUILD_NOKEEPALIVE", "-noKeepAlive"));
            }
            if (this.cloud.getDisableHttpsCertValidation().booleanValue()) {
                mylist.add(this.createEnvVariable("JENKINS_CODEBUILD_DISABLE_SSL_VALIDATION", "-disableHttpsCertValidation"));
            }
        } else if (this.cloud.getWebSocket().booleanValue()) {
            mylist.add(this.createEnvVariable("JENKINS_WEB_SOCKET", "true"));
            mylist.add(this.createEnvVariable("JENKINS_URL", this.cloud.getJenkinsUrl()));
        } else {
            if (StringUtils.isNotEmpty((CharSequence)this.cloud.getTunnel())) {
                mylist.add(this.createEnvVariable("JENKINS_TUNNEL", this.cloud.getTunnel()));
            }
            mylist.add(this.createEnvVariable("JENKINS_URL", this.cloud.getJenkinsUrl()));
            if (StringUtils.isNotEmpty((CharSequence)proxyCredentials)) {
                mylist.add(this.createEnvVariable("JENKINS_CODEBUILD_PROXY_CREDENTIALS", "-proxyCredentials " + proxyCredentials));
            }
            if (this.cloud.getNoKeepAlive().booleanValue()) {
                mylist.add(this.createEnvVariable("JENKINS_CODEBUILD_NOKEEPALIVE", "-noKeepAlive"));
            }
            if (this.cloud.getDisableHttpsCertValidation().booleanValue()) {
                mylist.add(this.createEnvVariable("JENKINS_CODEBUILD_DISABLE_SSL_VALIDATION", "-disableHttpsCertValidation"));
            }
        }
        if (this.cloud.getNoReconnect().booleanValue()) {
            mylist.add(this.createEnvVariable("JENKINS_CODEBUILD_NORECONNECT", "-noreconnect"));
        }
        mylist.add(this.createEnvVariable("JENKINS_SECRET", computer.getJnlpMac()));
        mylist.add(this.createEnvVariable("JENKINS_AGENT_NAME", node.getDisplayName()));
        try {
            URL myurl = new URL(this.cloud.getJenkinsUrl());
            mylist.add(this.createEnvVariable("JENKINS_CODEBUILD_AGENT_URL", myurl.getProtocol() + "://" + myurl.getAuthority() + "/jnlpJars/agent.jar"));
        }
        catch (MalformedURLException e) {
            mylist.add(this.createEnvVariable("JENKINS_CODEBUILD_AGENT_URL", "ERROR"));
        }
        return mylist;
    }

    private EnvironmentVariable createEnvVariable(String key, String value) {
        EnvironmentVariable var1 = new EnvironmentVariable();
        var1.setName(key);
        var1.setType("PLAINTEXT");
        var1.setValue(value);
        return var1;
    }
}

