/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.codebuildcloud;

import hudson.model.Executor;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import io.jenkins.plugins.codebuildcloud.CodeBuildAgent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CodeBuildComputer
extends AbstractCloudComputer<CodeBuildAgent> {
    private static final Logger LOGGER = Logger.getLogger(CodeBuildComputer.class.getName());
    private String buildId;
    private boolean completedWithoutErrors = false;

    public CodeBuildComputer(CodeBuildAgent agent) {
        super((AbstractCloudSlave)agent);
    }

    String getBuildId() {
        return this.buildId;
    }

    boolean getCompletedWithoutErrors() {
        return this.completedWithoutErrors;
    }

    void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        super.taskAccepted(executor, task);
        LOGGER.log(Level.INFO, "[{0}]: JobName: {1}", new Object[]{this.getName(), task.getDisplayName()});
        LOGGER.log(Level.INFO, "[{0}]: JobUrl: {1}", new Object[]{this.getName(), task.getUrl()});
        LOGGER.log(Level.FINE, "[{0}]: taskAccepted", (Object)this);
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        super.taskCompleted(executor, task, durationMS);
        LOGGER.log(Level.FINE, "[{0}]: taskCompleted", (Object)this);
        this.completedWithoutErrors = true;
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        LOGGER.severe(String.format("[%s]: Task in job '%s' completed with problems in %sms", new Object[]{this, task.getFullDisplayName(), durationMS}));
        this.completedWithoutErrors = false;
    }

    public String toString() {
        return String.format("name: %s buildID: %S Node: %s", this.getName(), this.getBuildId(), this.getNode());
    }
}

