/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.codebuildcloud;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.codebuild.model.EnvironmentType;
import com.amazonaws.services.codebuild.model.ImagePullCredentialsType;
import com.amazonaws.services.codebuild.model.ListProjectsRequest;
import com.amazonaws.services.codebuild.model.ListProjectsResult;
import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsHelper;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.codebuildcloud.CodeBuildAgent;
import io.jenkins.plugins.codebuildcloud.CodeBuildClientWrapper;
import io.jenkins.plugins.codebuildcloud.CodeBuildClientWrapperFactory;
import io.jenkins.plugins.codebuildcloud.CodeBuildLauncher;
import io.jenkins.plugins.codebuildcloud.Messages;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class CodeBuildCloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(CodeBuildCloud.class.getName());
    private static final Integer DEFAULT_AGENT_CONNECT_TIMEOUT = 180;
    private static final Integer DEFAULT_MAX_AGENTS = 50;
    private static final String DEFAULT_PROTOCOLS = "JNLP4-connect";
    private static final Boolean DEFAULT_NORECONNECT = true;
    @NonNull
    private String codeBuildProjectName;
    @NonNull
    private String credentialId;
    @NonNull
    private String region;
    @NonNull
    private String label;
    @NonNull
    private Integer agentConnectTimeout;
    @NonNull
    private Secret controllerIdentity;
    @NonNull
    private String direct;
    @NonNull
    private Boolean verifyIsCodeBuildIPOnJNLP;
    @NonNull
    private Boolean disableHttpsCertValidation;
    @NonNull
    private Boolean noKeepAlive;
    @NonNull
    private Boolean noReconnect;
    @NonNull
    private String protocols;
    @NonNull
    private String proxyCredentialsId;
    @NonNull
    private String tunnel;
    @NonNull
    private String jenkinsUrl;
    @NonNull
    private Boolean webSocket;
    @NonNull
    private String dockerImage;
    @NonNull
    private String computeType;
    @NonNull
    private String environmentType;
    @NonNull
    private String buildSpec;
    @NonNull
    private String dockerImagePullCredentials;
    @Nonnull
    private Integer maxAgents;
    private transient long lastProvisionTime = 0L;
    private transient CodeBuildClientWrapper client;

    @DataBoundConstructor
    public CodeBuildCloud(@NonNull String name, @NonNull String codeBuildProjectName, @NonNull String credentialId, @NonNull String region, @NonNull String label, @NonNull Integer agentConnectTimeout, @NonNull String dockerImage, @NonNull String dockerImagePullCredentials, @NonNull String computeType, @NonNull String environmentType, @NonNull String buildSpec, @NonNull Boolean verifyIsCodeBuildIPOnJNLP, @NonNull Integer maxAgents, @NonNull String direct, @NonNull Boolean disableHttpsCertValidation, @NonNull Boolean noKeepAlive, @NonNull Boolean noReconnect, @NonNull String protocols, @NonNull String proxyCredentialsId, @NonNull String tunnel, @NonNull String jenkinsUrl, @NonNull Boolean webSocket) throws NotImplementedException {
        super(name);
        this.codeBuildProjectName = codeBuildProjectName;
        this.credentialId = credentialId;
        this.region = region;
        this.label = label;
        this.agentConnectTimeout = agentConnectTimeout;
        this.dockerImage = dockerImage;
        this.computeType = computeType;
        this.environmentType = environmentType;
        this.buildSpec = buildSpec;
        this.dockerImagePullCredentials = dockerImagePullCredentials;
        this.verifyIsCodeBuildIPOnJNLP = verifyIsCodeBuildIPOnJNLP;
        this.maxAgents = maxAgents;
        this.direct = direct;
        this.disableHttpsCertValidation = disableHttpsCertValidation;
        this.noKeepAlive = noKeepAlive;
        this.noReconnect = noReconnect;
        this.protocols = protocols;
        this.proxyCredentialsId = proxyCredentialsId;
        this.tunnel = tunnel;
        this.jenkinsUrl = jenkinsUrl;
        this.webSocket = webSocket;
        String myIdentity = InstanceIdentity.get().getEncodedPublicKey();
        if (myIdentity == null) {
            throw new NotImplementedException("Failed to find Jenkins Identity");
        }
        this.controllerIdentity = Secret.fromString((String)myIdentity);
        if (maxAgents == null || maxAgents == 0) {
            this.maxAgents = DEFAULT_MAX_AGENTS;
        }
        LOGGER.info(" Initializing Cloud");
    }

    private void logConfig() {
        LOGGER.info("CodeBuild name: " + this.name);
        LOGGER.info("CodeBuild Project Name: " + this.codeBuildProjectName);
        LOGGER.info("CodeBuild credentialId: " + this.credentialId);
        LOGGER.info("CodeBuild region: " + this.region);
        LOGGER.info("CodeBuild label: " + this.label);
        LOGGER.info("CodeBuild agentTimeout: " + this.agentConnectTimeout);
        LOGGER.info("CodeBuild dockerImage: " + this.dockerImage);
        LOGGER.info("CodeBuild dockerImagePullCredentials: " + this.dockerImagePullCredentials);
        LOGGER.info("CodeBuild verifyIsCodeBuildIPOnJNLP: " + this.verifyIsCodeBuildIPOnJNLP);
        LOGGER.info("Codebuild maxAgents:" + this.maxAgents);
        LOGGER.info("CodeBuild computeType: " + this.computeType);
        LOGGER.info("CodeBuild direct: " + this.direct);
        LOGGER.info("CodeBuild disableHttpsCertValidation: " + this.disableHttpsCertValidation);
        LOGGER.info("CodeBuild noKeepAlive: " + this.noKeepAlive);
        LOGGER.info("CodeBuild noReconnect: " + this.noReconnect);
        LOGGER.info("CodeBuild protocols: " + this.protocols);
        LOGGER.info("CodeBuild proxyCredentialsId: " + this.proxyCredentialsId);
        LOGGER.info("CodeBuild tunnel: " + this.tunnel);
        LOGGER.info("CodeBuild jenkinsUrl: " + this.jenkinsUrl);
        LOGGER.info("CodeBuild webSocket: " + this.webSocket);
        LOGGER.info("CodeBuild controllerIdentity: " + this.controllerIdentity.getPlainText());
        LOGGER.info("CodeBuild environmentType: " + this.environmentType);
        LOGGER.info("CodeBuild buildSpec: " + this.buildSpec);
        LOGGER.info("Codebuild Cloud relative URL: " + this.getUrl());
    }

    private static void clearAllNodes() {
        List nodes = CodeBuildCloud.getJenkins().getNodes();
        if (nodes.size() == 0) {
            return;
        }
        LOGGER.info("Clearing all previous  nodes...");
        for (Node n : nodes) {
            if (!(n instanceof CodeBuildAgent)) continue;
            try {
                ((CodeBuildAgent)n).terminate();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.SEVERE, String.format("Failed to terminate agent '%s'", n.getDisplayName()), e);
            }
        }
    }

    @NonNull
    protected static Jenkins getJenkins() {
        Jenkins instance = Jenkins.get();
        Objects.requireNonNull(instance, "Jenkins must not be null");
        return instance;
    }

    public String getName() {
        return this.name;
    }

    @NonNull
    public String getCodeBuildProjectName() {
        return this.codeBuildProjectName;
    }

    @DataBoundSetter
    public void setCodeBuildProjectName(String codeBuildProjectName) {
        this.codeBuildProjectName = codeBuildProjectName;
    }

    @NonNull
    public String getRegion() {
        return this.region;
    }

    @DataBoundSetter
    public void setRegion(String region) {
        this.region = region;
    }

    @NonNull
    public String getLabel() {
        return this.label;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = label;
    }

    @NonNull
    public Integer getAgentConnectTimeout() {
        return this.agentConnectTimeout;
    }

    @DataBoundSetter
    public void setAgentConnectTimeout(Integer agentTimeout) {
        this.agentConnectTimeout = agentTimeout;
    }

    @NonNull
    public String getCredentialId() {
        return this.credentialId;
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    @NonNull
    public Secret getControllerIdentity() {
        return this.controllerIdentity;
    }

    @DataBoundSetter
    public void setControllerIdentity(Secret controllerIdentity) {
        this.controllerIdentity = controllerIdentity;
    }

    @NonNull
    public Integer getMaxAgents() {
        return this.maxAgents;
    }

    @DataBoundSetter
    public void setMaxAgents(Integer maxAgents) {
        this.maxAgents = maxAgents;
    }

    @NonNull
    public String getDirect() {
        return this.direct;
    }

    @DataBoundSetter
    public void setDirect(String direct) {
        this.direct = direct;
    }

    @NonNull
    public Boolean getDisableHttpsCertValidation() {
        return this.disableHttpsCertValidation;
    }

    @DataBoundSetter
    public void setDisableHttpsCertValidation(Boolean disableHttpsCertValidation) {
        this.disableHttpsCertValidation = disableHttpsCertValidation;
    }

    @NonNull
    public Boolean getNoKeepAlive() {
        return this.noKeepAlive;
    }

    @DataBoundSetter
    public void setNoKeepAlive(Boolean noKeepAlive) {
        this.noKeepAlive = noKeepAlive;
    }

    @NonNull
    public Boolean getNoReconnect() {
        return this.noReconnect;
    }

    @DataBoundSetter
    public void setNoReconnect(Boolean noReconnect) {
        this.noReconnect = noReconnect;
    }

    @NonNull
    public String getProtocols() {
        return this.protocols;
    }

    @DataBoundSetter
    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    @NonNull
    public String getProxyCredentialsId() {
        return this.proxyCredentialsId;
    }

    @DataBoundSetter
    public void setProxyCredentialsId(String proxyCredentialsId) {
        this.proxyCredentialsId = proxyCredentialsId;
    }

    @NonNull
    public String getTunnel() {
        return this.tunnel;
    }

    @DataBoundSetter
    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    @NonNull
    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    @DataBoundSetter
    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
    }

    @NonNull
    public Boolean getWebSocket() {
        return this.webSocket;
    }

    @DataBoundSetter
    public void setWebSocket(Boolean webSocket) {
        this.webSocket = webSocket;
    }

    @NonNull
    public Boolean getVerifyIsCodeBuildIPOnJNLP() {
        return this.verifyIsCodeBuildIPOnJNLP;
    }

    @DataBoundSetter
    public void setVerifyIsCodeBuildIPOnJNLP(Boolean verifyIsCodeBuildIPOnJNLP) {
        this.verifyIsCodeBuildIPOnJNLP = verifyIsCodeBuildIPOnJNLP;
    }

    @NonNull
    public String getDockerImage() {
        return this.dockerImage;
    }

    @DataBoundSetter
    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    @NonNull
    public String getDockerImagePullCredentials() {
        return this.dockerImagePullCredentials;
    }

    @DataBoundSetter
    public void setDockerImagePullCredentials(String dockerImagePullCredentials) {
        this.dockerImagePullCredentials = dockerImagePullCredentials;
    }

    @NonNull
    public String getComputeType() {
        return this.computeType;
    }

    @DataBoundSetter
    public void setComputeType(String computeType) {
        this.computeType = computeType;
    }

    @NonNull
    public String getEnvironmentType() {
        return this.environmentType;
    }

    @DataBoundSetter
    public void setEnvironmentType(String environmentType) {
        this.environmentType = environmentType;
    }

    @NonNull
    public String getBuildSpec() {
        return this.buildSpec;
    }

    @DataBoundSetter
    public void setBuildSpec(String buildSpec) {
        this.buildSpec = buildSpec;
    }

    private long getLastProvisionTime() {
        LOGGER.finest("Current Provision time: " + String.valueOf(this.lastProvisionTime));
        return this.lastProvisionTime;
    }

    private void setLastProvisionTime(long provisionTime) {
        LOGGER.finest("Setting Provision time: " + String.valueOf(provisionTime));
        this.lastProvisionTime = provisionTime;
    }

    public String toString() {
        return String.format("%s<%s>", this.name, this.codeBuildProjectName);
    }

    public boolean canProvision(Label label) {
        boolean canProv = false;
        if (label != null) {
            canProv = label.matches(Arrays.asList(new LabelAtom(this.getLabel())));
        }
        LOGGER.finest(String.format("Check provisioning capabilities for label '%s': %s", label, canProv));
        return canProv;
    }

    public synchronized CodeBuildClientWrapper getClient() {
        if (this.client == null) {
            this.client = CodeBuildClientWrapperFactory.buildClient(this.credentialId, this.region, CodeBuildCloud.getJenkins());
        }
        return this.client;
    }

    private long countStillProvisioning() {
        long mycount = 0L;
        for (Node s : CodeBuildCloud.getJenkins().getNodes()) {
            if (!(s instanceof CodeBuildAgent)) continue;
            CodeBuildAgent d = (CodeBuildAgent)s;
            if (!((Object)((Object)d.cloud)).equals((Object)this) || d.terminated || !d.getLauncher().isLaunchSupported()) continue;
            ++mycount;
        }
        return mycount;
    }

    private long totalProvisionedOrProvisioning() {
        long mycount = 0L;
        for (Node s : CodeBuildCloud.getJenkins().getNodes()) {
            if (!(s instanceof CodeBuildAgent)) continue;
            CodeBuildAgent d = (CodeBuildAgent)s;
            if (!((Object)((Object)d.cloud)).equals((Object)this) || d.terminated) continue;
            ++mycount;
        }
        return mycount;
    }

    private long totalCanProvision() {
        long totalConcurrentJobsPossibleFromCBP = this.getClient().getMaxConcurrentJobs(this.codeBuildProjectName).intValue();
        long totalProvisioned = this.totalProvisionedOrProvisioning();
        LOGGER.finest("Total concurrent jobs from CB: " + totalConcurrentJobsPossibleFromCBP);
        LOGGER.finest("Total concurrent jobs running/provisioning right now: " + totalProvisioned);
        long totalPossibleToProvisionFromCB = totalConcurrentJobsPossibleFromCBP - totalProvisioned;
        long totalPossibleToProvisionFromPlugin = (long)this.getMaxAgents().intValue() - totalProvisioned;
        return Math.min(totalPossibleToProvisionFromCB, totalPossibleToProvisionFromPlugin);
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        ArrayList<NodeProvisioner.PlannedNode> list = new ArrayList<NodeProvisioner.PlannedNode>();
        if (!this.canProvision(label)) {
            return list;
        }
        long totalPossibleToProvision = this.totalCanProvision();
        if (totalPossibleToProvision <= 0L) {
            LOGGER.finest(String.format("Cannot provision, detected our maximum possible to provision is <= 0 currently: %s.)", totalPossibleToProvision));
            return list;
        }
        long timeDiff = System.currentTimeMillis() - this.getLastProvisionTime();
        LOGGER.finest("Diff in provison time: " + String.valueOf(timeDiff));
        if (timeDiff < 5000L) {
            LOGGER.finest(String.format("Provision of %s skipped, still on cooldown %sms of 5 seconds)", excessWorkload, timeDiff));
            return list;
        }
        long numToLaunch = Math.min(totalPossibleToProvision, (long)excessWorkload);
        if (numToLaunch == 0L) {
            LOGGER.finest(String.format("Provision of excess workload (%s) skipped, total can launch is 0", excessWorkload));
            return list;
        }
        String labelName = label == null ? this.getLabel() : label.getDisplayName();
        LOGGER.info(String.format("Provisioning %s nodes for label '%s' (%s already provisioning)", numToLaunch, labelName, this.countStillProvisioning()));
        int i = 0;
        while ((long)i < numToLaunch) {
            String suffix = RandomStringUtils.randomAlphabetic((int)4);
            String displayName = String.format("%s.%s", this.name, suffix);
            CodeBuildCloud cloud = this;
            Future<Node> nodeResolver = Computer.threadPoolForRemoting.submit(() -> {
                CodeBuildLauncher launcher = new CodeBuildLauncher(cloud);
                CodeBuildAgent agent = new CodeBuildAgent(displayName, cloud, (ComputerLauncher)launcher);
                CodeBuildCloud.getJenkins().addNode((Node)agent);
                return agent;
            });
            list.add(new NodeProvisioner.PlannedNode(displayName, nodeResolver, 1));
            ++i;
        }
        this.setLastProvisionTime(System.currentTimeMillis());
        return list;
    }

    static {
        CodeBuildCloud.clearAllNodes();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        private static String CLOUD_NAME_PATTERN = "[a-z|A-Z|0-9|_|-]{1,100}";

        private FormValidation checkValue(String value, String error) {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            if (value.length() != 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)error);
        }

        private FormValidation checkValue(String value, Integer min, Integer max, String error) {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            try {
                Integer newval = Integer.parseInt(value);
                if (newval <= max && newval >= min) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)(error + ": Was outside of bounds of allowed values.  Min: " + min + " Max: " + max));
            }
            catch (Exception e) {
                return FormValidation.error((String)(error + "  Exception: " + e.toString()));
            }
        }

        @POST
        public ListBoxModel doFillCredentialIdItems(@AncestorInPath ItemGroup context) {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            return AWSCredentialsHelper.doFillCredentialsIdItems((ItemGroup)context);
        }

        @POST
        public FormValidation doCheckLabel(@QueryParameter String value) {
            return this.checkValue(value, "Must include a label");
        }

        @POST
        public FormValidation doCheckCredentialId(@QueryParameter String value) {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckProxyCredentialsId(@QueryParameter String value) {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillDockerImagePullCredentialsItems() {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            StandardListBoxModel options = new StandardListBoxModel();
            options.includeEmptyValue();
            for (ImagePullCredentialsType thetype : ImagePullCredentialsType.values()) {
                options.add(thetype.name());
            }
            return options;
        }

        @POST
        public FormValidation doCheckDockerImage(@QueryParameter String value) {
            return this.checkValue(value, "Must put in a valid docker image string");
        }

        @POST
        public FormValidation doCheckDockerImagePullCredentials(@QueryParameter String value) {
            return this.checkValue(value, "Must pick the Credential Type to pull the image for AWS CodeBuild service.");
        }

        @POST
        public ListBoxModel doFillProxyCredentialsIdItems(@QueryParameter String value) {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            AbstractIdCredentialsListBoxModel result = new StandardUsernameListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, (ItemGroup)CodeBuildCloud.getJenkins(), StandardUsernamePasswordCredentials.class);
            return result;
        }

        @POST
        public ListBoxModel doFillRegionItems() {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            StandardListBoxModel options = new StandardListBoxModel();
            options.includeEmptyValue();
            for (Region r : RegionUtils.getRegionsForService((String)"codebuild")) {
                options.add(r.getName());
            }
            return options;
        }

        @POST
        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value != null && value.length() > 0 && value.length() <= 100 && value.matches(CLOUD_NAME_PATTERN)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)("Should match the following REGEX: '" + CLOUD_NAME_PATTERN + "'"));
        }

        @POST
        public FormValidation doCheckRegion(@QueryParameter String value) {
            return this.checkValue(value, "Must include a region");
        }

        @POST
        public ListBoxModel doFillCodeBuildProjectNameItems(@QueryParameter String credentialId, @QueryParameter String region) {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            StandardListBoxModel options = new StandardListBoxModel();
            options.includeEmptyValue();
            ArrayList codebuildProjects = new ArrayList();
            try {
                ListProjectsResult result;
                CodeBuildClientWrapper client = CodeBuildClientWrapperFactory.buildClient(credentialId, region, CodeBuildCloud.getJenkins());
                String nextToken = null;
                do {
                    result = client.listProjects(new ListProjectsRequest().withNextToken(nextToken));
                    codebuildProjects.addAll(result.getProjects());
                } while ((nextToken = result.getNextToken()) != null);
            }
            catch (AmazonClientException e) {
                if (e.getMessage().contains("Unable to load AWS credentials")) {
                    LOGGER.warning(" Exception listing codebuild project because of no valid AWS credentials. Exception: " + e.toString());
                    return options;
                }
                if (e.getMessage().contains("The security token included in the request is invalid")) {
                    LOGGER.warning(" Exception listing codebuild project because of INVALID AWS credentials Exception: " + e.toString());
                    return options;
                }
                LOGGER.log(Level.SEVERE, "Unhandled AWS Exception listing CodeBuild Projects: " + e.toString());
                return options;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unhandled General Exception listing CodeBuild Projects: " + e.toString());
                return options;
            }
            Collections.sort(codebuildProjects);
            for (String item : codebuildProjects) {
                options.add(item);
            }
            return options;
        }

        @POST
        public FormValidation doCheckCodeBuildProjectName(@QueryParameter String value) {
            return this.checkValue(value, "Invalid CodeBuild project selected");
        }

        @POST
        public FormValidation doCheckBuildSpec(@QueryParameter String value) {
            CodeBuildCloud.getJenkins().checkPermission(Jenkins.ADMINISTER);
            try {
                new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(value);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)("Incorrect YAML DEFINITION: " + e.toString()));
            }
        }

        @POST
        public ListBoxModel doFillEnvironmentTypeItems() {
            StandardListBoxModel options = new StandardListBoxModel();
            options.includeEmptyValue();
            ArrayList<String> envTypes = new ArrayList<String>();
            for (EnvironmentType theValue : EnvironmentType.values()) {
                envTypes.add(theValue.name());
            }
            Collections.sort(envTypes);
            for (String envtype : envTypes) {
                options.add(envtype);
            }
            return options;
        }

        @POST
        public FormValidation doCheckEnvironmentType(@QueryParameter String value) {
            return this.checkValue(value, "Must include an EnvironmentType");
        }

        @POST
        public ListBoxModel doFillComputeTypeItems() {
            StandardListBoxModel options = new StandardListBoxModel();
            options.includeEmptyValue();
            options.add("BUILD_GENERAL1_SMALL");
            options.add("BUILD_GENERAL1_MEDIUM");
            options.add("BUILD_GENERAL1_LARGE");
            options.add("BUILD_GENERAL1_2XLARGE");
            return options;
        }

        @POST
        public FormValidation doCheckComputeType(@QueryParameter String value) {
            return this.checkValue(value, "Must include a Compute Type");
        }

        @POST
        public FormValidation doCheckAgentConnectTimeout(@QueryParameter String value) {
            return this.checkValue(value, 120, Integer.MAX_VALUE, "Invalid Agent Timeout Specified. ");
        }

        @POST
        public Integer getDefaultAgentConnectTimeout() {
            return DEFAULT_AGENT_CONNECT_TIMEOUT;
        }

        @POST
        public Integer getDefaultMaxAgents() {
            return DEFAULT_MAX_AGENTS;
        }

        @POST
        public FormValidation doCheckMaxAgents(@QueryParameter String value) {
            return this.checkValue(value, 1, Integer.MAX_VALUE, "Invalid Max Agent Specified. ");
        }

        @POST
        public String getDefaultJenkinsUrl() {
            JenkinsLocationConfiguration config = JenkinsLocationConfiguration.get();
            return StringUtils.defaultIfBlank((String)config.getUrl(), (String)"unknown");
        }

        @POST
        public FormValidation doCheckJenkinsUrl(@QueryParameter String value) {
            if (value.length() > 0) {
                try {
                    new URL(value);
                }
                catch (MalformedURLException e) {
                    return FormValidation.error((String)("Invalid Jenkins URL: Exception: " + e.toString()));
                }
            }
            return FormValidation.ok();
        }

        @POST
        public String getDefaultProtocols() {
            return CodeBuildCloud.DEFAULT_PROTOCOLS;
        }

        @POST
        public Boolean getDefaultNoReconnect() {
            return DEFAULT_NORECONNECT;
        }

        @POST
        public String getDefaultRegion() {
            try {
                return new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (AmazonClientException exc) {
                return "";
            }
        }

        public String getDisplayName() {
            return Messages.CodeBuildCloud_DescriptorImpl_DisplayName();
        }
    }
}

