/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.codebuildcloud;

import com.amazonaws.services.codebuild.model.ResourceNotFoundException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.RetentionStrategy;
import io.jenkins.plugins.codebuildcloud.CodeBuildCloud;
import io.jenkins.plugins.codebuildcloud.CodeBuildComputer;
import io.jenkins.plugins.codebuildcloud.CodeBuildLauncher;
import io.jenkins.plugins.codebuildcloud.CodeBuildRetentionStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class CodeBuildAgent
extends AbstractCloudSlave {
    final transient CodeBuildCloud cloud;
    private static final Logger LOGGER = Logger.getLogger(CodeBuildAgent.class.getName());
    private static final long serialVersionUID = 1L;
    transient boolean terminated = false;

    public CodeBuildAgent(String name, @NonNull CodeBuildCloud cloud, @NonNull ComputerLauncher launcher) throws Descriptor.FormException, IOException {
        super(name, "/build", launcher);
        this.setNodeDescription("CodeBuild Agent");
        this.setNumExecutors(1);
        this.setMode(Node.Mode.EXCLUSIVE);
        this.setLabelString(cloud.getLabel());
        this.setRetentionStrategy((RetentionStrategy)new CodeBuildRetentionStrategy());
        this.setNodeProperties(Collections.emptyList());
        this.cloud = cloud;
    }

    public AbstractCloudComputer<CodeBuildAgent> createComputer() {
        return new CodeBuildComputer(this);
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Terminating agent: " + this.getDisplayName());
        LOGGER.finest("Terminating agent: " + this.getDisplayName());
        if (this.getLauncher() instanceof CodeBuildLauncher) {
            CodeBuildComputer comp = (CodeBuildComputer)this.getComputer();
            if (comp == null) {
                this.terminated = true;
                return;
            }
            String buildId = comp.getBuildId();
            if (StringUtils.isBlank((String)buildId)) {
                this.terminated = true;
                return;
            }
            LOGGER.finest("Terminating agent Step2: " + this.getDisplayName());
            try {
                if (!comp.getCompletedWithoutErrors()) {
                    this.cloud.getClient().stopBuild(buildId);
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
            }
            catch (Exception e) {
                LOGGER.severe(String.format("Failed to stop build ID: %s.  Exception: %s", buildId, e));
            }
            this.terminated = true;
        }
    }
}

