/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.status;

import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.checks.api.ChecksOutput;
import java.util.Optional;
import java.util.logging.Logger;

abstract class AbstractRunAnalyzer {
    protected static final Logger LOGGER = Logger.getLogger(AbstractRunAnalyzer.class.getName());
    protected static final String TRUNCATED_MESSAGE = "\n\nOutput truncated.";
    protected static final String TRUNCATED_MESSAGE_BUILD_LOG = "Build log truncated.\n\n";
    protected static final int MAX_MESSAGE_SIZE_TO_CHECKS_API = 65535;
    protected static final String LOG_DETAILS_TEMPLATE = "<details><summary>Build Log</summary>%n%n```%n%s%n```%n%n</details>";
    private final Run<?, ?> run;
    private final boolean suppressLogs;

    protected AbstractRunAnalyzer(Run<?, ?> run, boolean suppressLogs) {
        this.run = run;
        this.suppressLogs = suppressLogs;
    }

    protected Run<?, ?> getRun() {
        return this.run;
    }

    protected boolean isSuppressLogs() {
        return this.suppressLogs;
    }

    public abstract ChecksOutput extractOutput();

    protected String extractOutputTitle(Optional<String> title) {
        Result result = this.getRun().getResult();
        if (result == null) {
            return "In progress";
        }
        if (result.isBetterOrEqualTo(Result.SUCCESS)) {
            return "Success";
        }
        if (title.isPresent()) {
            return title.get();
        }
        if (result.isBetterOrEqualTo(Result.UNSTABLE)) {
            return "Unstable";
        }
        if (result.isBetterOrEqualTo(Result.FAILURE)) {
            return "Failure";
        }
        if (result.isBetterOrEqualTo(Result.NOT_BUILT)) {
            return "Skipped";
        }
        if (result.isBetterOrEqualTo(Result.ABORTED)) {
            return "Aborted";
        }
        throw new IllegalStateException("Unsupported run result: " + String.valueOf(result));
    }
}

