/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.util;

import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import java.util.Optional;

public class LoggingChecksPublisher
extends ChecksPublisher {
    private Formatter formatter = ChecksDetails::toString;
    private TaskListener listener = TaskListener.NULL;

    public void publish(ChecksDetails details) {
        this.listener.getLogger().print(this.formatter.format(details));
    }

    @FunctionalInterface
    public static interface Formatter {
        public String format(ChecksDetails var1);
    }

    public static class Factory
    extends ChecksPublisherFactory {
        private final LoggingChecksPublisher publisher = new LoggingChecksPublisher();

        public Factory() {
        }

        public Factory(Formatter formatter) {
            this.publisher.formatter = formatter;
        }

        public void setFormatter(Formatter formatter) {
            this.publisher.formatter = formatter;
        }

        protected Optional<ChecksPublisher> createPublisher(Run<?, ?> run, TaskListener listener) {
            this.publisher.listener = listener;
            return Optional.of(this.publisher);
        }

        protected Optional<ChecksPublisher> createPublisher(Job<?, ?> job, TaskListener listener) {
            this.publisher.listener = listener;
            return Optional.of(this.publisher);
        }
    }
}

