/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.theme.catppuccin;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.UnprotectedRootAction;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@Extension
public class CatppuccinRootAction
implements UnprotectedRootAction {
    private static final Set<String> THEMES = Set.of("catppuccin-latte.css", "catppuccin-frappe.css", "catppuccin-macchiato.css", "catppuccin-mocha.css");

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "theme-catppuccin";
    }

    public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        String cssFile = req.getRestOfPath();
        if (cssFile.startsWith("/")) {
            cssFile = cssFile.substring(1);
        }
        if (!THEMES.contains(cssFile)) {
            rsp.sendError(404);
            return;
        }
        Plugin plugin = Jenkins.get().getPlugin("catppuccin-theme");
        if (plugin == null) {
            rsp.sendError(404);
            return;
        }
        plugin.doDynamic(req, rsp);
    }
}

