/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden.converters;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.mwdle.bitwarden.Messages;
import com.mwdle.bitwarden.cli.BitwardenCLI;
import com.mwdle.bitwarden.cli.BitwardenSessionManager;
import com.mwdle.bitwarden.converters.CredentialConverter;
import com.mwdle.bitwarden.model.BitwardenItem;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Logger;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;

public class CredentialProxy
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CredentialProxy.class.getName());
    private final String credentialId;
    private final String itemId;
    private final String itemName;
    private final String itemDescription;
    private final transient Descriptor<?> itemDescriptor;
    private volatile transient StandardCredentials resolvedCredential;

    public CredentialProxy(String credentialId, String itemId, String itemName, Descriptor<?> itemDescriptor) {
        this.credentialId = credentialId;
        this.itemId = itemId;
        this.itemName = itemName;
        this.itemDescriptor = itemDescriptor;
        boolean isFileType = FileCredentials.class.isAssignableFrom(itemDescriptor.clazz);
        boolean isDuplicate = !credentialId.equals(this.itemName);
        Object duplicateLabel = isDuplicate ? ", " + Messages.description_nonUniqueLabel() : "";
        String idString = String.format("%s %s%s", Messages.description_idLabel(), this.itemId, duplicateLabel);
        this.itemDescription = isFileType ? idString : String.format("%s (%s)", this.itemName, idString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws IOException, InterruptedException {
        String methodName = method.getName();
        switch (methodName) {
            case "getDescriptor": {
                return this.itemDescriptor;
            }
            case "getId": {
                return this.credentialId;
            }
            case "getDescription": {
                return this.itemDescription;
            }
            case "getScope": {
                return CredentialsScope.GLOBAL;
            }
            case "forRun": {
                return proxy;
            }
            case "toString": {
                return "BitwardenCredentialProxy(itemId=" + this.itemId + ")";
            }
            case "hashCode": {
                return this.itemId.hashCode();
            }
            case "getFileName": {
                return this.itemName;
            }
            case "isUsernameSecret": {
                return true;
            }
            case "getPassphrase": {
                return Secret.fromString((String)"");
            }
        }
        if (this.resolvedCredential == null) {
            Object object = this;
            synchronized (object) {
                if (this.resolvedCredential == null) {
                    this.resolvedCredential = this.resolveFullCredential();
                }
            }
        }
        try {
            return method.invoke((Object)this.resolvedCredential, args);
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Failed to invoke method on resolved Bitwarden credential.");
        }
    }

    private StandardCredentials resolveFullCredential() throws IOException, InterruptedException {
        LOGGER.fine(() -> "Performing one-time lazy fetch for Bitwarden item: " + this.itemId);
        BitwardenItem item = BitwardenCLI.getItem(BitwardenSessionManager.getInstance().getSessionToken(), this.itemId);
        if (item == null) {
            throw new IOException("Bitwarden item with ID " + this.itemId + " not found or could not be parsed.");
        }
        CredentialConverter converter = CredentialConverter.findConverter(item);
        if (converter != null) {
            return converter.convert(CredentialsScope.GLOBAL, this.credentialId, this.itemDescription, item);
        }
        throw new IOException("No suitable converter found for Bitwarden item ID: " + this.itemId);
    }
}

