/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum BitwardenItemType {
    LOGIN(1),
    SECURE_NOTE(2),
    CARD(3),
    IDENTITY(4),
    SSH_KEY(5),
    UNKNOWN(0);

    private final int typeCode;

    private BitwardenItemType(int typeCode) {
        this.typeCode = typeCode;
    }

    @JsonCreator
    public static BitwardenItemType fromInteger(int typeCode) {
        return Stream.of(BitwardenItemType.values()).filter(type -> type.typeCode == typeCode).findFirst().orElse(UNKNOWN);
    }

    @JsonValue
    public int getTypeCode() {
        return this.typeCode;
    }
}

