/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden.converters;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.mwdle.bitwarden.converters.CredentialConverter;
import com.mwdle.bitwarden.converters.CredentialProxy;
import com.mwdle.bitwarden.model.BitwardenItem;
import com.mwdle.bitwarden.model.BitwardenItemMetadata;
import com.mwdle.bitwarden.model.BitwardenItemType;
import com.mwdle.bitwarden.model.BitwardenSshKey;
import hudson.Extension;
import hudson.model.Descriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class SshKeyConverter
extends CredentialConverter {
    private static final Logger LOGGER = Logger.getLogger(SshKeyConverter.class.getName());

    private static String getUsername(BitwardenSshKey sshKeyData) {
        String[] parts;
        String username = "";
        String publicKey = sshKeyData.getPublicKey();
        if (publicKey != null && (parts = publicKey.trim().split("\\s+")).length > 2) {
            String comment = parts[parts.length - 1];
            username = comment.split("@")[0];
        }
        return username;
    }

    @Override
    public boolean canConvert(BitwardenItemMetadata metadata) {
        return metadata.getItemType() == BitwardenItemType.SSH_KEY;
    }

    @Override
    public boolean canConvert(BitwardenItem item) {
        BitwardenSshKey sshKeyData = item.getSshKey();
        boolean canConvert = sshKeyData != null && sshKeyData.getPrivateKey() != null;
        LOGGER.fine(() -> "canConvert: item id=" + item.getId() + " name='" + item.getName() + "' canConvert=" + canConvert);
        return canConvert;
    }

    public SSHUserPrivateKey createProxy(CredentialsScope scope, String id, BitwardenItemMetadata metadata) {
        LOGGER.fine(() -> "Creating PROXY credential for SSH key: " + metadata.getId());
        Descriptor descriptor = Jenkins.get().getDescriptor(BasicSSHUserPrivateKey.class);
        if (descriptor == null) {
            LOGGER.warning("Descriptor for BasicSSHUserPrivateKey not found. Is the SSH Credentials plugin installed and enabled?");
            return null;
        }
        CredentialProxy handler = new CredentialProxy(id, metadata.getId(), metadata.getName(), descriptor);
        return (SSHUserPrivateKey)Proxy.newProxyInstance(SSHUserPrivateKey.class.getClassLoader(), new Class[]{SSHUserPrivateKey.class}, (InvocationHandler)handler);
    }

    public BasicSSHUserPrivateKey convert(CredentialsScope scope, String id, String description, BitwardenItem item) {
        LOGGER.fine(() -> "convert: id=" + id + " item id=" + item.getId() + " name='" + item.getName() + "'");
        BitwardenSshKey sshKeyData = item.getSshKey();
        String username = SshKeyConverter.getUsername(sshKeyData);
        LOGGER.fine(() -> "convert: derived username='" + username + "'");
        BasicSSHUserPrivateKey.DirectEntryPrivateKeySource privateKeySource = new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(sshKeyData.getPrivateKey());
        return new BasicSSHUserPrivateKey(scope, id, username, (BasicSSHUserPrivateKey.PrivateKeySource)privateKeySource, "", description);
    }
}

