/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.mwdle.bitwarden.BitwardenCacheManager;
import com.mwdle.bitwarden.BitwardenConfig;
import com.mwdle.bitwarden.BitwardenCredentialsStore;
import com.mwdle.bitwarden.converters.CredentialConverter;
import com.mwdle.bitwarden.model.BitwardenItemMetadata;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.springframework.security.core.Authentication;

@Extension
public class BitwardenCredentialsProvider
extends CredentialsProvider {
    private static final Logger LOGGER = Logger.getLogger(BitwardenCredentialsProvider.class.getName());
    private final transient BitwardenCredentialsStore store = new BitwardenCredentialsStore(this);

    public static BitwardenCredentialsProvider getInstance() {
        return (BitwardenCredentialsProvider)((Object)CredentialsProvider.all().get(BitwardenCredentialsProvider.class));
    }

    public CredentialsStore getStore(ModelObject object) {
        if (object instanceof Jenkins) {
            return this.store;
        }
        return null;
    }

    public List<Credentials> listCredentials() {
        if (!BitwardenConfig.getInstance().isConfigured()) {
            return Collections.emptyList();
        }
        List<BitwardenItemMetadata> bitwardenItemMetadata = BitwardenCacheManager.getInstance().getMetadata();
        Set duplicateNames = bitwardenItemMetadata.stream().map(BitwardenItemMetadata::getName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        bitwardenItemMetadata.forEach(metadata -> {
            CredentialConverter converter = CredentialConverter.findConverter(metadata);
            if (converter != null) {
                String jenkinsId = duplicateNames.contains(metadata.getName()) ? metadata.getId() : metadata.getName();
                result.add((Credentials)converter.createProxy(CredentialsScope.GLOBAL, jenkinsId, (BitwardenItemMetadata)metadata));
            }
        });
        return result;
    }

    @Nonnull
    public <C extends Credentials> List<C> getCredentialsInItemGroup(@Nonnull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nonnull List<DomainRequirement> domainRequirements) {
        LOGGER.fine(() -> "getCredentialsInItemGroup: type=" + type.getSimpleName() + " itemGroup=" + (itemGroup != null ? itemGroup.getFullName() : "null") + " authentication=" + (authentication != null ? authentication.getName() : "null"));
        if (itemGroup == null || authentication == null) {
            LOGGER.fine("getCredentialsInItemGroup: itemGroup or authentication is null \u2014 returning empty list");
            return Collections.emptyList();
        }
        List<Credentials> allCredentials = this.listCredentials();
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        for (Credentials c : allCredentials) {
            if (!type.isInstance(c)) continue;
            result.add((Credentials)type.cast(c));
        }
        return result;
    }

    public String getIconClassName() {
        return "symbol-icon plugin-bitwarden-credentials-provider";
    }
}

