/*
 * Decompiled with CFR 0.152.
 */
package com.mwdle.bitwarden.cli;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mwdle.bitwarden.Messages;
import com.mwdle.bitwarden.PluginDirectoryProvider;
import com.mwdle.bitwarden.cli.BitwardenAuthenticationException;
import com.mwdle.bitwarden.cli.BitwardenCLIManager;
import com.mwdle.bitwarden.cli.BitwardenConnectionException;
import com.mwdle.bitwarden.model.BitwardenItem;
import com.mwdle.bitwarden.model.BitwardenItemMetadata;
import com.mwdle.bitwarden.model.BitwardenStatus;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public final class BitwardenCLI {
    private static final Logger LOGGER = Logger.getLogger(BitwardenCLI.class.getName());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private BitwardenCLI() {
    }

    private static ProcessBuilder bitwardenCommand(String ... command) {
        String executablePath = BitwardenCLIManager.getInstance().getExecutablePath();
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add(executablePath);
        commandParts.addAll(Arrays.asList(command));
        LOGGER.fine(() -> "Building Bitwarden command: " + String.join((CharSequence)" ", commandParts));
        return new ProcessBuilder(commandParts);
    }

    public static String version() throws IOException, InterruptedException {
        LOGGER.info("Fetching Bitwarden CLI version");
        ProcessBuilder pb = BitwardenCLI.bitwardenCommand("--version");
        return BitwardenCLI.executeCommand(pb);
    }

    public static void login(StandardUsernamePasswordCredentials apiKey) throws IOException, InterruptedException {
        LOGGER.info("Logging in with API key credentials.");
        ProcessBuilder pb = BitwardenCLI.bitwardenCommand("login", "--apikey");
        Map<String, String> env = pb.environment();
        env.put("BW_CLIENTID", apiKey.getUsername());
        env.put("BW_CLIENTSECRET", apiKey.getPassword().getPlainText());
        try {
            BitwardenCLI.executeCommand(pb);
            LOGGER.info("Login successful.");
        }
        catch (IOException e) {
            if (e.getMessage().contains("FetchError")) {
                throw new BitwardenConnectionException(Messages.exception_connectionError(), e);
            }
            if (e.getMessage().contains("Username or password is incorrect") || e.getMessage().contains("Invalid API Key") || e.getMessage().contains("Incorrect client_secret")) {
                throw new BitwardenAuthenticationException(Messages.exception_loginError(), e);
            }
            throw e;
        }
    }

    public static void logout() throws InterruptedException {
        LOGGER.info("Logging out...");
        ProcessBuilder pb = BitwardenCLI.bitwardenCommand("logout");
        try {
            BitwardenCLI.executeCommand(pb);
            LOGGER.info("Logout successful.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Secret unlock(StringCredentials masterPassword) throws IOException, InterruptedException {
        LOGGER.info("Unlocking vault.");
        ProcessBuilder pb = BitwardenCLI.bitwardenCommand("unlock", "--raw", "--passwordenv", "BITWARDEN_MASTER_PASSWORD");
        Map<String, String> env = pb.environment();
        env.put("BITWARDEN_MASTER_PASSWORD", masterPassword.getSecret().getPlainText());
        try {
            return Secret.fromString((String)BitwardenCLI.executeCommand(pb));
        }
        catch (IOException e) {
            if (e.getMessage().contains("FetchError")) {
                throw new BitwardenConnectionException(Messages.exception_connectionError(), e);
            }
            if (e.getMessage().contains("Invalid master password")) {
                throw new BitwardenAuthenticationException(Messages.exception_unlockError(), e);
            }
            throw e;
        }
    }

    public static void sync(Secret sessionToken) throws IOException, InterruptedException {
        LOGGER.info("Syncing vault.");
        ProcessBuilder pb = BitwardenCLI.bitwardenCommand("sync");
        pb.environment().put("BW_SESSION", Secret.toString((Secret)sessionToken));
        try {
            BitwardenCLI.executeCommand(pb);
            LOGGER.info("Vault sync complete.");
        }
        catch (IOException e) {
            if (e.getMessage().contains("FetchError")) {
                throw new BitwardenConnectionException(Messages.exception_syncError(), e);
            }
            throw e;
        }
    }

    public static BitwardenStatus status(Secret sessionToken) throws IOException, InterruptedException {
        LOGGER.fine("Fetching CLI status.");
        ProcessBuilder pb = BitwardenCLI.bitwardenCommand("status");
        pb.environment().put("BW_SESSION", Secret.toString((Secret)sessionToken));
        String json = BitwardenCLI.executeCommand(pb);
        LOGGER.fine(() -> "CLI status fetched successfully. JSON: " + json);
        return (BitwardenStatus)OBJECT_MAPPER.readValue(json, BitwardenStatus.class);
    }

    public static List<BitwardenItemMetadata> listItemsMetadata(Secret sessionToken) throws IOException, InterruptedException {
        ProcessBuilder pb = BitwardenCLI.bitwardenCommand("list", "items");
        pb.environment().put("BW_SESSION", Secret.toString((Secret)sessionToken));
        String json = BitwardenCLI.executeCommand(pb);
        List metadataList = (List)OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<List<BitwardenItemMetadata>>(){});
        LOGGER.info(() -> "Successfully deserialized metadata for " + metadataList.size() + " items.");
        return metadataList;
    }

    public static BitwardenItem getItem(Secret sessionToken, String itemId) throws IOException, InterruptedException {
        LOGGER.fine(() -> "Fetching single vault item with ID: " + itemId);
        ProcessBuilder pb = BitwardenCLI.bitwardenCommand("get", "item", itemId);
        pb.environment().put("BW_SESSION", Secret.toString((Secret)sessionToken));
        String json = BitwardenCLI.executeCommand(pb);
        LOGGER.fine(() -> "Single vault item " + itemId + " fetched successfully.");
        return (BitwardenItem)OBJECT_MAPPER.readValue(json, BitwardenItem.class);
    }

    public static void configServer(String serverUrl) throws IOException, InterruptedException {
        LOGGER.info(() -> "Configuring server URL: " + serverUrl);
        BitwardenCLI.executeCommand(BitwardenCLI.bitwardenCommand("config", "server", serverUrl));
        LOGGER.info("Server URL configured successfully.");
    }

    private static String executeCommand(ProcessBuilder pb) throws IOException, InterruptedException {
        LOGGER.fine(() -> "Executing command: " + String.join((CharSequence)" ", pb.command()));
        Map<String, String> env = pb.environment();
        File bitwardenDataDir = new File(PluginDirectoryProvider.getPluginDataDirectory().getAbsolutePath(), "bwcli");
        env.put("BITWARDENCLI_APPDATA_DIR", bitwardenDataDir.getAbsolutePath());
        pb.redirectErrorStream(true);
        Process process = pb.start();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new IOException("Command failed with exit code " + exitCode + ". Output: " + String.valueOf(output));
        }
        return output.toString().trim();
    }
}

