/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.v2;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.damnhandy.uri.template.UriTemplate;
import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import io.jenkins.plugins.bitbucket.webhook.JsonParser;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.PostWebhooksEventType;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.v2.PostWebhook2Payload;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.v2.PostWebhooks2Configuration;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.v2.trait.PostWebhooks2ConfigurationTrait;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@Extension
public class PostWebhooks2Manager
implements BitbucketWebhookManager {
    private static final String WEBHOOK_API = "/rest/webhook/2.0/configurations{/id}{?projectKey,repositorySlug}";
    private static final Logger logger = Logger.getLogger(PostWebhooks2Manager.class.getName());
    private static final List<PostWebhooksEventType> PLUGIN_SERVER_EVENTS = Collections.unmodifiableList(List.of(PostWebhooksEventType.ABSTRACT_REPOSITORY_REFS_CHANGED, PostWebhooksEventType.BRANCH_CREATED, PostWebhooksEventType.BRANCH_DELETED, PostWebhooksEventType.PULL_REQUEST_DECLINED, PostWebhooksEventType.PULL_REQUEST_DELETED, PostWebhooksEventType.PULL_REQUEST_MERGED, PostWebhooksEventType.PULL_REQUEST_OPENED, PostWebhooksEventType.PULL_REQUEST_REOPENED, PostWebhooksEventType.PULL_REQUEST_UPDATED, PostWebhooksEventType.PULL_REQUEST_RESCOPED, PostWebhooksEventType.REPOSITORY_MIRROR_SYNCHRONIZED, PostWebhooksEventType.TAG_CREATED));
    private PostWebhooks2Configuration configuration;
    private String callbackURL;
    private String[] ignoredSources;
    private String[] ignoredUsers;
    private String[] ignoredGroups;
    private boolean ignoreCerts;
    private boolean ignoreURLValidation;
    private boolean skipCI;

    public Collection<Class<? extends SCMSourceTrait>> supportedTraits() {
        return List.of(PostWebhooks2ConfigurationTrait.class);
    }

    public void apply(SCMSourceTrait trait) {
        if (trait instanceof PostWebhooks2ConfigurationTrait) {
            PostWebhooks2ConfigurationTrait cfgTrait = (PostWebhooks2ConfigurationTrait)trait;
            this.ignoredSources = StringUtils.split((String)Util.fixEmptyAndTrim((String)cfgTrait.getIgnoredSources()), (char)',');
            this.ignoredUsers = StringUtils.split((String)Util.fixEmptyAndTrim((String)cfgTrait.getIgnoredUsers()), (char)',');
            this.ignoredGroups = StringUtils.split((String)Util.fixEmptyAndTrim((String)cfgTrait.getIgnoredGroups()), (char)',');
            this.ignoreCerts = cfgTrait.isIgnoreCerts();
            this.ignoreURLValidation = cfgTrait.isIgnoreURLValidation();
            this.skipCI = cfgTrait.isSkipCI();
        }
    }

    public void apply(BitbucketWebhookConfiguration configuration) {
        this.configuration = (PostWebhooks2Configuration)configuration;
    }

    public void setCallbackURL(@NonNull String callbackURL, @NonNull BitbucketEndpoint endpoint) {
        this.callbackURL = UriTemplate.buildFromTemplate((String)callbackURL).query(new String[]{"server_url"}).build().set("server_url", (Object)endpoint.getServerURL()).expand();
    }

    @NonNull
    public Collection<BitbucketWebHook> read(@NonNull BitbucketAuthenticatedClient client) throws IOException {
        String endpointJenkinsRootURL = (String)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> this.configuration.getEndpointJenkinsRootURL(), () -> BitbucketWebhookConfiguration.getDefaultJenkinsRootURL()});
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("projectKey", (Object)client.getRepositoryOwner()).set("repositorySlug", (Object)client.getRepositoryName()).expand();
        PostWebhook2Payload[] hooks = JsonParser.toJava(client.get(url), PostWebhook2Payload[].class);
        return Stream.of(hooks).map(BitbucketWebHook.class::cast).filter(hook -> hook.getUrl().startsWith(endpointJenkinsRootURL)).toList();
    }

    @NonNull
    private PostWebhook2Payload buildPayload(String owner, String repoSlug) {
        PostWebhook2Payload hook = new PostWebhook2Payload();
        hook.setActive(true);
        hook.setDescription("Jenkins hook");
        hook.setDestinations(new PostWebhook2Payload.Destination[]{new PostWebhook2Payload.Destination(this.callbackURL)});
        hook.setEventTypes(PLUGIN_SERVER_EVENTS);
        hook.setProjectKey(owner);
        hook.setRepositorySlug(repoSlug);
        if (ArrayUtils.isNotEmpty((Object[])this.ignoredSources)) {
            PostWebhook2Payload.Source[] sources = (PostWebhook2Payload.Source[])Stream.of(this.ignoredSources).filter(StringUtils::isNotEmpty).map(source -> new PostWebhook2Payload.Source(owner, repoSlug, (String)source)).toArray(PostWebhook2Payload.Source[]::new);
            hook.setIgnoredSources(sources);
        }
        if (ArrayUtils.isNotEmpty((Object[])this.ignoredUsers)) {
            hook.setIgnoredUsers(this.ignoredUsers);
        }
        if (ArrayUtils.isNotEmpty((Object[])this.ignoredGroups)) {
            hook.setIgnoredGroups(this.ignoredGroups);
        }
        hook.setIgnoreCerts(this.ignoreCerts);
        hook.setIgnoreURLValidation(this.ignoreURLValidation);
        hook.setSkipCI(this.skipCI);
        return hook;
    }

    private void register(@NonNull PostWebhook2Payload payload, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).expand();
        client.post(url, (Object)payload);
    }

    private boolean shouldUpdate(@NonNull PostWebhook2Payload current, @NonNull PostWebhook2Payload expected) {
        List<PostWebhooksEventType> expectedEvents;
        List<PostWebhooksEventType> events;
        boolean update = false;
        if (!Arrays.deepEquals(current.getIgnoredUsers(), expected.getIgnoredUsers())) {
            current.setIgnoredUsers(expected.getIgnoredUsers());
            logger.info(() -> "Update ignoredUsers");
            update = true;
        }
        if (!Arrays.deepEquals(current.getIgnoredGroups(), expected.getIgnoredGroups())) {
            current.setIgnoredGroups(expected.getIgnoredGroups());
            logger.info(() -> "Update ignoredGroups");
            update = true;
        }
        if (!Arrays.deepEquals(current.getIgnoredSources(), expected.getIgnoredSources())) {
            current.setIgnoredSources(expected.getIgnoredSources());
            logger.info(() -> "Update ignoredSources");
            update = true;
        }
        if (current.isIgnoreCerts() != expected.isIgnoreCerts()) {
            current.setIgnoreCerts(expected.isIgnoreCerts());
            logger.info(() -> "Update ignoreCerts to " + expected.isIgnoreCerts());
            update = true;
        }
        if (current.isIgnoreURLValidation() != expected.isIgnoreURLValidation()) {
            current.setIgnoreURLValidation(expected.isIgnoreURLValidation());
            logger.info(() -> "Update ignoreURLValidation to " + expected.isIgnoreURLValidation());
            update = true;
        }
        if (current.isSkipCI() != expected.isSkipCI()) {
            current.setSkipCI(expected.isSkipCI());
            logger.info(() -> "Update skipCI to " + expected.isSkipCI());
            update = true;
        }
        if (!current.isActive()) {
            current.setActive(true);
            logger.info(() -> "Re-activate webhook " + current.getUuid());
            update = true;
        }
        if (!Objects.equal((Object)current.getUrl(), (Object)expected.getUrl())) {
            logger.info(() -> "Update webhook " + current.getUuid() + " callback URL");
            current.setDestinations(new PostWebhook2Payload.Destination[]{new PostWebhook2Payload.Destination(expected.getUrl())});
            update = true;
        }
        if (!(events = current.getEventTypes()).containsAll(expectedEvents = expected.getEventTypes())) {
            TreeSet<PostWebhooksEventType> newEvents = new TreeSet<PostWebhooksEventType>(events);
            newEvents.addAll(expectedEvents);
            current.setEventTypes(new ArrayList<PostWebhooksEventType>(newEvents));
            logger.info(() -> "Update webhook " + current.getUuid() + " events because was missing: " + String.valueOf(CollectionUtils.subtract((Iterable)expectedEvents, (Iterable)events)));
            update = true;
        }
        return update;
    }

    private void update(@NonNull PostWebhook2Payload payload, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("id", (Object)payload.getUuid()).expand();
        client.put(url, (Object)payload);
    }

    public void remove(@NonNull String webhookId, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_API).set("id", (Object)webhookId).expand();
        client.delete(url);
    }

    public void register(@NonNull BitbucketAuthenticatedClient client) throws IOException {
        PostWebhook2Payload existingHook = this.read(client).stream().findFirst().orElse(null);
        PostWebhook2Payload payload = this.buildPayload(client.getRepositoryOwner(), client.getRepositoryName());
        if (existingHook == null) {
            logger.log(Level.INFO, "Registering cloud hook for {0}/{1}", new Object[]{client.getRepositoryOwner(), client.getRepositoryName()});
            this.register(payload, client);
        } else if (this.shouldUpdate(existingHook, payload)) {
            logger.log(Level.INFO, "Updating cloud hook for {0}/{1}", new Object[]{client.getRepositoryOwner(), client.getRepositoryName()});
            this.update(existingHook, client);
        }
    }
}

