/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.AbstractPostWebhookProcessor;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.PostWebhooksEventType;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.PostWebhooksPushEvent;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.WebhookPayload;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;

@Extension
public class PostWebhooksProcessor
extends AbstractPostWebhookProcessor {
    private static final Logger logger = Logger.getLogger(PostWebhooksProcessor.class.getName());

    @Override
    protected List<PostWebhooksEventType> getSupportedEvents() {
        return List.of(PostWebhooksEventType.ABSTRACT_REPOSITORY_REFS_CHANGED);
    }

    public void process(@NonNull String eventType, @NonNull String payload, @NonNull Map<String, Object> context, @NonNull BitbucketEndpoint endpoint) {
        BitbucketPushEvent push = WebhookPayload.pushEventFromPayload(payload);
        if (push != null) {
            if (push.getChanges().isEmpty()) {
                String owner = push.getRepository().getOwnerName();
                String repository = push.getRepository().getRepositoryName();
                logger.log(Level.INFO, "Received push hook with empty changes from Bitbucket for {0}/{1}. Skipping.", new Object[]{owner, repository});
            } else {
                SCMEvent.Type type = null;
                for (BitbucketPushEvent.Change change : push.getChanges()) {
                    if ((type == null || type == SCMEvent.Type.CREATED) && change.isCreated()) {
                        type = SCMEvent.Type.CREATED;
                        continue;
                    }
                    if ((type == null || type == SCMEvent.Type.REMOVED) && change.isClosed()) {
                        type = SCMEvent.Type.REMOVED;
                        continue;
                    }
                    type = SCMEvent.Type.UPDATED;
                }
                this.notifyEvent(new PostWebhooksPushEvent(type, push, this.getOrigin(context)), BitbucketSCMSource.getEventDelaySeconds());
            }
        }
    }
}

