/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public enum PostWebhooksEventType {
    TAG_CREATED(null),
    BRANCH_DELETED(null),
    BRANCH_CREATED(null),
    REPOSITORY_MIRROR_SYNCHRONIZED(null),
    ABSTRACT_REPOSITORY_REFS_CHANGED("repo:push"),
    PULL_REQUEST_DECLINED("pullrequest:rejected"),
    PULL_REQUEST_MERGED("pullrequest:fulfilled"),
    PULL_REQUEST_UPDATED("pullrequest:updated"),
    PULL_REQUEST_RESCOPED("pullrequest:rescoped"),
    PULL_REQUEST_REOPENED(null),
    PULL_REQUEST_OPENED("pullrequest:created"),
    PULL_REQUEST_COMMENT("pullrequest:comment"),
    PULL_REQUEST_CANCELABLE_COMMENT(null),
    PULL_REQUEST_COMMENT_ACTIVITY(null),
    PULL_REQUEST_DELETED("pullrequest:deleted"),
    BUILD_STATUS_SET("build:status");

    private final String headerName;

    private PostWebhooksEventType(String headerName) {
        this.headerName = headerName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    @CheckForNull
    public static PostWebhooksEventType fromHeader(@Nullable String headerValue) {
        for (PostWebhooksEventType value : PostWebhooksEventType.values()) {
            if (!Objects.equal((Object)value.getHeaderName(), (Object)headerValue)) continue;
            return value;
        }
        return null;
    }
}

