/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.v1;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentialsUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.bitbucket.webhook.Messages;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.v1.PostWebhooksManager;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class PostWebhooksConfiguration
implements BitbucketWebhookConfiguration {
    private boolean manageHooks;
    @CheckForNull
    private String credentialsId;
    private String endpointJenkinsRootURL;

    @DataBoundConstructor
    public PostWebhooksConfiguration(boolean manageHooks, @CheckForNull String credentialsId) {
        this.manageHooks = manageHooks && StringUtils.isNotBlank((CharSequence)credentialsId);
        this.credentialsId = manageHooks ? Util.fixEmptyAndTrim((String)credentialsId) : null;
    }

    public final boolean isManageHooks() {
        return this.manageHooks;
    }

    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    public String getEndpointJenkinsRootURL() {
        return this.endpointJenkinsRootURL;
    }

    @DataBoundSetter
    public void setEndpointJenkinsRootURL(@CheckForNull String endpointJenkinsRootURL) {
        this.endpointJenkinsRootURL = Util.fixEmptyAndTrim((String)endpointJenkinsRootURL);
    }

    public String getDisplayName() {
        return Messages.PostWebhooksImplementation_displayName();
    }

    @NonNull
    public String getId() {
        return "POST_WEBHOOKS";
    }

    public Class<? extends BitbucketWebhookManager> getManager() {
        return PostWebhooksManager.class;
    }

    @Symbol(value={"postWebhooks"})
    @Extension
    public static class DescriptorImpl
    extends BitbucketWebhookDescriptor {
        public String getDisplayName() {
            return Messages.PostWebhooksConfiguration_displayName();
        }

        public boolean isApplicable(@NonNull EndpointType type) {
            return type == EndpointType.SERVER;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter(fixEmpty=true) String credentialsId, @QueryParameter(value="serverURL", fixEmpty=true) String serverURL) {
            Jenkins jenkins = DescriptorImpl.checkPermission();
            return BitbucketCredentialsUtils.listCredentials((ItemGroup)jenkins, (String)serverURL, (String)credentialsId);
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public static FormValidation doCheckEndpointJenkinsRootURL(@QueryParameter String value) {
            DescriptorImpl.checkPermission();
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            return FormValidation.ok();
        }

        private static Jenkins checkPermission() {
            Jenkins jenkins = Jenkins.get();
            jenkins.checkPermission(Jenkins.MANAGE);
            return jenkins;
        }
    }
}

