/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.AbstractSCMHeadEvent;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang3.StringUtils;

final class PostWebhooksPushEvent
extends AbstractSCMHeadEvent<BitbucketPushEvent> {
    PostWebhooksPushEvent(SCMEvent.Type type, BitbucketPushEvent payload, String origin) {
        super(type, payload, origin);
    }

    @NonNull
    public String getSourceName() {
        return this.getRepository().getRepositoryName();
    }

    @NonNull
    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
        if (!(source instanceof BitbucketSCMSource)) {
            return Collections.emptyMap();
        }
        BitbucketSCMSource src = (BitbucketSCMSource)source;
        if (!this.isServerURLMatch(src.getServerUrl())) {
            return Collections.emptyMap();
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)src.getRepoOwner(), (CharSequence)((BitbucketPushEvent)this.getPayload()).getRepository().getOwnerName())) {
            return Collections.emptyMap();
        }
        if (!src.getRepository().equalsIgnoreCase(((BitbucketPushEvent)this.getPayload()).getRepository().getRepositoryName())) {
            return Collections.emptyMap();
        }
        HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>();
        for (BitbucketPushEvent.Change change : ((BitbucketPushEvent)this.getPayload()).getChanges()) {
            if (change.isClosed()) {
                result.put((SCMHead)new BranchSCMHead(change.getOld().getName()), null);
                continue;
            }
            BitbucketPushEvent.Reference newChange = change.getNew();
            BitbucketPushEvent.Target target = newChange.getTarget();
            BranchSCMHead head = null;
            String eventType = newChange.getType();
            if ("tag".equals(eventType)) {
                Date tagDate;
                Date date = tagDate = newChange.getDate() != null ? newChange.getDate() : target.getDate();
                if (tagDate == null) {
                    tagDate = new Date();
                }
                head = new BitbucketTagSCMHead(newChange.getName(), tagDate.getTime());
            } else {
                head = new BranchSCMHead(newChange.getName());
            }
            result.put((SCMHead)head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, target.getHash()));
        }
        return result;
    }

    @Override
    protected BitbucketRepository getRepository() {
        return ((BitbucketPushEvent)this.getPayload()).getRepository();
    }
}

