/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessorException;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerWebhookPayload;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor.PostWebhooksPREvent;
import java.util.List;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;

@Extension
public class PostWebhooksPullRequestProcessor
implements BitbucketWebhookProcessor {
    private static final String SERVER_URL_PARAMETER = "server_url";
    private static final String EVENT_TYPE_HEADER = "X-Event-Key";
    private static final List<String> supportedEvents = List.of(HookEventType.PULL_REQUEST_CREATED.getKey(), HookEventType.PULL_REQUEST_DECLINED.getKey(), HookEventType.PULL_REQUEST_MERGED.getKey(), HookEventType.PULL_REQUEST_UPDATED.getKey());

    @NonNull
    public String getServerURL(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        String serverURL = parameters.get((Object)SERVER_URL_PARAMETER).stream().findFirst().orElse(null);
        if (StringUtils.isBlank((CharSequence)serverURL)) {
            throw new BitbucketWebhookProcessorException(400, "server_url query parameter not found or empty. Refer to the user documentation on how configure the webHook in Bitbucket at https://github.com/jenkinsci/bitbucket-branch-source-plugin/blob/master/docs/USER_GUIDE.adoc#webhooks-registering");
        }
        return serverURL;
    }

    @NonNull
    public String getEventType(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        String eventType = headers.get(EVENT_TYPE_HEADER);
        if (StringUtils.isEmpty((CharSequence)eventType)) {
            throw new IllegalStateException("X-Event-Key is missing or empty, this processor should not proceed after canHandle method. Please fill an issue at https://issues.jenkins.io reporting this stacktrace.");
        }
        return eventType;
    }

    public boolean canHandle(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        return headers.containsKey(EVENT_TYPE_HEADER) && headers.containsKey("X-Bitbucket-Type") && supportedEvents.contains(headers.get(EVENT_TYPE_HEADER)) && parameters.containsKey((Object)SERVER_URL_PARAMETER);
    }

    public void process(@NonNull String hookEventType, @NonNull String payload, @NonNull Map<String, Object> context, @NonNull BitbucketEndpoint endpoint) {
        HookEventType hookEvent = HookEventType.fromString((String)hookEventType);
        BitbucketPullRequestEvent pull = BitbucketServerWebhookPayload.pullRequestEventFromPayload((String)payload);
        if (pull != null) {
            this.notifyEvent(new PostWebhooksPREvent(switch (hookEvent) {
                case HookEventType.PULL_REQUEST_CREATED -> SCMEvent.Type.CREATED;
                case HookEventType.PULL_REQUEST_DECLINED, HookEventType.PULL_REQUEST_MERGED -> SCMEvent.Type.REMOVED;
                default -> SCMEvent.Type.UPDATED;
            }, pull, this.getOrigin(context), hookEvent), BitbucketSCMSource.getEventDelaySeconds());
        }
    }

    private String getOrigin(Map<String, Object> context) {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{(String)context.get("origin"), "unknow"});
    }

    public void verifyPayload(Map<String, String> headers, String body, BitbucketEndpoint endpoint) {
    }
}

