/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.bitbucket.webhook.moveworkforward.processor;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.events.BitbucketCloudPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.client.events.BitbucketCloudPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.BitbucketServerPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.BitbucketServerPushEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

abstract class AbstractSCMHeadEvent<P>
extends SCMHeadEvent<P> {
    AbstractSCMHeadEvent(SCMEvent.Type type, P payload, String origin) {
        super(type, payload, origin);
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        if (!(navigator instanceof BitbucketSCMNavigator)) {
            return false;
        }
        BitbucketSCMNavigator bbNav = (BitbucketSCMNavigator)navigator;
        if (!this.isProjectKeyMatch(bbNav.getProjectKey())) {
            return false;
        }
        if (!this.isServerURLMatch(bbNav.getServerUrl())) {
            return false;
        }
        return Strings.CI.equals(bbNav.getRepoOwner(), this.getRepository().getOwnerName());
    }

    protected abstract BitbucketRepository getRepository();

    private boolean isProjectKeyMatch(String projectKey) {
        if (StringUtils.isBlank((CharSequence)projectKey)) {
            return true;
        }
        BitbucketRepository repository = this.getRepository();
        if (repository.getProject() != null) {
            return projectKey.equals(repository.getProject().getKey());
        }
        return true;
    }

    protected boolean isServerURLMatch(String serverURL) {
        if (serverURL == null) {
            if (this.getPayload() instanceof BitbucketServerPullRequestEvent || this.getPayload() instanceof BitbucketServerPushEvent) {
                return false;
            }
        } else {
            if (this.getPayload() instanceof BitbucketCloudPullRequestEvent || this.getPayload() instanceof BitbucketCloudPushEvent) {
                return false;
            }
            Map links = this.getRepository().getLinks();
            if (links != null && links.containsKey("self")) {
                boolean matches = false;
                for (BitbucketHref link : (List)links.get("self")) {
                    try {
                        URI navUri = new URI(serverURL);
                        URI evtUri = new URI(link.getHref());
                        if (!navUri.getHost().equalsIgnoreCase(evtUri.getHost())) continue;
                        matches = true;
                        break;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                }
                return matches;
            }
        }
        return true;
    }

    public boolean isMatch(@NonNull SCM scm) {
        return false;
    }
}

