// CHECKSTYLE:OFF

package io.jenkins.plugins.bitbucket.webhook;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code PostWebhooks2Configuration.displayName}: {@code Post
     * Webhooks for Bitbucket REST 2.0 - Experimental}.
     * 
     * @return
     *     {@code Post Webhooks for Bitbucket REST 2.0 - Experimental}
     */
    public static String PostWebhooks2Configuration_displayName() {
        return holder.format("PostWebhooks2Configuration.displayName");
    }

    /**
     * Key {@code PostWebhooks2Configuration.displayName}: {@code Post
     * Webhooks for Bitbucket REST 2.0 - Experimental}.
     * 
     * @return
     *     {@code Post Webhooks for Bitbucket REST 2.0 - Experimental}
     */
    public static Localizable _PostWebhooks2Configuration_displayName() {
        return new Localizable(holder, "PostWebhooks2Configuration.displayName");
    }

    /**
     * Key {@code PostWebhooksConfiguration.displayName}: {@code Post
     * Webhooks for Bitbucket REST 1.0}.
     * 
     * @return
     *     {@code Post Webhooks for Bitbucket REST 1.0}
     */
    public static String PostWebhooksConfiguration_displayName() {
        return holder.format("PostWebhooksConfiguration.displayName");
    }

    /**
     * Key {@code PostWebhooksConfiguration.displayName}: {@code Post
     * Webhooks for Bitbucket REST 1.0}.
     * 
     * @return
     *     {@code Post Webhooks for Bitbucket REST 1.0}
     */
    public static Localizable _PostWebhooksConfiguration_displayName() {
        return new Localizable(holder, "PostWebhooksConfiguration.displayName");
    }

    /**
     * Key {@code PostWebhooksImplementation.displayName}: {@code Post
     * Webhooks for Bitbucket Implementation}.
     * 
     * @return
     *     {@code Post Webhooks for Bitbucket Implementation}
     */
    public static String PostWebhooksImplementation_displayName() {
        return holder.format("PostWebhooksImplementation.displayName");
    }

    /**
     * Key {@code PostWebhooksImplementation.displayName}: {@code Post
     * Webhooks for Bitbucket Implementation}.
     * 
     * @return
     *     {@code Post Webhooks for Bitbucket Implementation}
     */
    public static Localizable _PostWebhooksImplementation_displayName() {
        return new Localizable(holder, "PostWebhooksImplementation.displayName");
    }

    /**
     * Key {@code PostWebhooks2Implementation.displayName}: {@code Post
     * Webhooks 2.0 for Bitbucket Implementation}.
     * 
     * @return
     *     {@code Post Webhooks 2.0 for Bitbucket Implementation}
     */
    public static String PostWebhooks2Implementation_displayName() {
        return holder.format("PostWebhooks2Implementation.displayName");
    }

    /**
     * Key {@code PostWebhooks2Implementation.displayName}: {@code Post
     * Webhooks 2.0 for Bitbucket Implementation}.
     * 
     * @return
     *     {@code Post Webhooks 2.0 for Bitbucket Implementation}
     */
    public static Localizable _PostWebhooks2Implementation_displayName() {
        return new Localizable(holder, "PostWebhooks2Implementation.displayName");
    }

    /**
     * Key {@code PostWebhooksConfigurationTrait.displayName}: {@code Post
     * Webhooks Trait}.
     * 
     * @return
     *     {@code Post Webhooks Trait}
     */
    public static String PostWebhooksConfigurationTrait_displayName() {
        return holder.format("PostWebhooksConfigurationTrait.displayName");
    }

    /**
     * Key {@code PostWebhooksConfigurationTrait.displayName}: {@code Post
     * Webhooks Trait}.
     * 
     * @return
     *     {@code Post Webhooks Trait}
     */
    public static Localizable _PostWebhooksConfigurationTrait_displayName() {
        return new Localizable(holder, "PostWebhooksConfigurationTrait.displayName");
    }

    /**
     * Key {@code PostWebhooks2ConfigurationTrait.displayName}: {@code Post
     * Webhooks 2.0 Trait}.
     * 
     * @return
     *     {@code Post Webhooks 2.0 Trait}
     */
    public static String PostWebhooks2ConfigurationTrait_displayName() {
        return holder.format("PostWebhooks2ConfigurationTrait.displayName");
    }

    /**
     * Key {@code PostWebhooks2ConfigurationTrait.displayName}: {@code Post
     * Webhooks 2.0 Trait}.
     * 
     * @return
     *     {@code Post Webhooks 2.0 Trait}
     */
    public static Localizable _PostWebhooks2ConfigurationTrait_displayName() {
        return new Localizable(holder, "PostWebhooks2ConfigurationTrait.displayName");
    }

}
