/*
 * Decompiled with CFR 0.152.
 */
package co.johnrowley.jenkins.bitbucketcredentialsk8s;

import com.atlassian.bitbucket.jenkins.internal.config.BitbucketTokenCredentialsImpl;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.util.Secret;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class BitbucketCredentialConverter
extends SecretToCredentialConverter {
    private static final Logger LOG = Logger.getLogger(BitbucketCredentialConverter.class.getName());

    public boolean canConvert(String type) {
        return "bitbucketToken".equals(type);
    }

    public BitbucketTokenCredentialsImpl convert(io.fabric8.kubernetes.api.model.Secret secret) throws CredentialsConvertionException {
        String bearerTokenBase64 = SecretUtils.getNonNullSecretData((io.fabric8.kubernetes.api.model.Secret)secret, (String)"text", (String)"bitbucketToken credential is missing the token (in the text property)");
        String bearerToken = (String)SecretUtils.requireNonNull((Object)BitbucketCredentialConverter.base64DecodeToString(bearerTokenBase64), (String)"bitbucketToken credential has an invalid token (the data in the text property must be base64 encoded UTF-8)");
        return new BitbucketTokenCredentialsImpl(SecretUtils.getCredentialId((io.fabric8.kubernetes.api.model.Secret)secret), SecretUtils.getCredentialDescription((io.fabric8.kubernetes.api.model.Secret)secret), Secret.fromString((String)bearerToken));
    }

    @CheckForNull
    private static byte[] base64Decode(String s) {
        try {
            return Base64.getDecoder().decode(s);
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.WARNING, "failed to base64decode Secret, is the format valid?  {0}", ex.getMessage());
            return null;
        }
    }

    @CheckForNull
    public static String base64DecodeToString(String s) {
        byte[] bytes = BitbucketCredentialConverter.base64Decode(s);
        if (bytes != null) {
            try {
                CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                CharBuffer decode = decoder.decode(ByteBuffer.wrap(bytes));
                return decode.toString();
            }
            catch (CharacterCodingException ex) {
                LOG.log(Level.WARNING, "failed to covert Secret, is this a valid UTF-8 string?  {0}", ex.getMessage());
            }
        }
        return null;
    }
}

