/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.azuresdk;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import hudson.ProxyConfiguration;
import hudson.Util;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.util.JenkinsJVM;
import jenkins.util.SystemProperties;

public class HttpClientRetriever {
    public static HttpClient get() {
        ProxyConfiguration proxy;
        if (JenkinsJVM.isJenkinsJVM() && (proxy = Jenkins.get().proxy) != null) {
            return HttpClientRetriever.get(proxy);
        }
        return HttpClientRetriever.getBuilder().build();
    }

    public static HttpClient get(ProxyConfiguration proxy) {
        ProxyOptions proxyOptions = null;
        if (proxy != null) {
            String noProxyHost;
            proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(proxy.name, proxy.port));
            if (proxy.getSecretPassword() != null && !proxy.getSecretPassword().getPlainText().equals("")) {
                proxyOptions.setCredentials(proxy.getUserName(), proxy.getSecretPassword().getPlainText());
            }
            if ((noProxyHost = Util.fixEmpty((String)proxy.getNoProxyHost())) != null) {
                proxyOptions.setNonProxyHosts(Arrays.stream(noProxyHost.split("[ \t\n,|]+")).filter(s -> !s.isEmpty()).collect(Collectors.joining("|")));
            }
        }
        return HttpClientRetriever.getBuilder().proxy(proxyOptions).build();
    }

    private static NettyAsyncHttpClientBuilder getBuilder() {
        Long writeTimeoutSeconds;
        Long responseTimeoutSeconds;
        NettyAsyncHttpClientBuilder builder = new NettyAsyncHttpClientBuilder();
        Long readTimeoutSeconds = SystemProperties.getLong((String)(HttpClientRetriever.class.getName() + ".readTimeoutSeconds"));
        if (readTimeoutSeconds != null) {
            builder.readTimeout(Duration.ofSeconds(readTimeoutSeconds));
        }
        if ((responseTimeoutSeconds = SystemProperties.getLong((String)(HttpClientRetriever.class.getName() + ".responseTimeoutSeconds"))) != null) {
            builder.responseTimeout(Duration.ofSeconds(responseTimeoutSeconds));
        }
        if ((writeTimeoutSeconds = SystemProperties.getLong((String)(HttpClientRetriever.class.getName() + ".writeTimeoutSeconds"))) != null) {
            builder.writeTimeout(Duration.ofSeconds(writeTimeoutSeconds));
        }
        return builder;
    }
}

