/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.azurecosmosdb;

import com.azure.cosmos.CosmosClient;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.util.AzureImdsCredentials;
import hudson.model.Item;
import io.jenkins.plugins.azurecosmosdb.AzureCosmosDBCredentials;
import io.jenkins.plugins.azurecosmosdb.AzureCosmosDBKeyCredentials;
import io.jenkins.plugins.azurecosmosdb.CredentialsHelper;
import java.time.Duration;
import java.util.Objects;
import jenkins.util.SystemProperties;

public class AzureCosmosDBCache {
    private static final long MAX_SIZE = SystemProperties.getLong((String)(AzureCosmosDBCache.class.getName() + ".MAX_CACHE_SIZE"), (Long)50L);
    private static final int CACHE_DURATION_HOURS = SystemProperties.getInteger((String)(AzureCosmosDBCache.class.getName() + ".CACHE_DURATION_HOURS"), (Integer)24);
    private static final Duration EXPIRE_AFTER = Duration.ofHours(CACHE_DURATION_HOURS);
    private static final LoadingCache<CacheKey, CosmosClient> CACHE = Caffeine.newBuilder().maximumSize(MAX_SIZE).evictionListener((k, v, c) -> {
        CosmosClient client = (CosmosClient)v;
        Objects.requireNonNull(client).close();
    }).expireAfterWrite(EXPIRE_AFTER).build(AzureCosmosDBCache::createClient);

    private AzureCosmosDBCache() {
    }

    static long cacheSize() {
        return CACHE.estimatedSize();
    }

    public static CosmosClient get(String credentialsId, Item item) {
        AzureCosmosDBCredentials credentials = AzureCosmosDBCache.lookupCredentials(credentialsId, item, AzureCosmosDBCredentials.class);
        StandardCredentials authCreds = AzureCosmosDBCache.lookupCredentials(credentials.getCredentialsId(), item, StandardCredentials.class);
        return (CosmosClient)CACHE.get((Object)new CacheKey(authCreds, credentials.getUrl(), credentials.getPreferredRegion()));
    }

    private static <T extends StandardCredentials> T lookupCredentials(String credentialsId, Item item, Class<T> type) {
        StandardCredentials credentials = CredentialsHelper.findCredentials(credentialsId, item);
        if (credentials != null && type.isAssignableFrom(credentials.getClass())) {
            return (T)((StandardCredentials)type.cast(credentials));
        }
        if (credentials == null) {
            throw new RuntimeException("Could not find credentials: " + credentialsId);
        }
        throw new RuntimeException("Unexpected credentials type: " + credentials.getClass().getSimpleName().replace("Impl", "") + " for ID: " + credentialsId);
    }

    public static void invalidateCache() {
        CACHE.invalidateAll();
    }

    private static CosmosClient createClient(CacheKey cacheKey) {
        return CredentialsHelper.createClient(cacheKey.cosmosAuthCredentials, cacheKey.preferredRegion, cacheKey.url);
    }

    static class CacheKey {
        private final StandardCredentials cosmosAuthCredentials;
        private final String url;
        private final String preferredRegion;

        CacheKey(StandardCredentials cosmosAuthCredentials, String url, String preferredRegion) {
            this.cosmosAuthCredentials = cosmosAuthCredentials;
            this.url = url;
            this.preferredRegion = preferredRegion;
        }

        public boolean equals(Object o) {
            boolean simpleTypesEqual;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            boolean bl = simpleTypesEqual = Objects.equals(this.cosmosAuthCredentials.getId(), cacheKey.cosmosAuthCredentials.getId()) && Objects.equals(this.url, cacheKey.url) && Objects.equals(this.preferredRegion, cacheKey.preferredRegion);
            if (!simpleTypesEqual) {
                return false;
            }
            if (this.cosmosAuthCredentials.getClass() != cacheKey.cosmosAuthCredentials.getClass()) {
                return false;
            }
            if (this.cosmosAuthCredentials instanceof AzureImdsCredentials) {
                AzureImdsCredentials imdsCredentials = (AzureImdsCredentials)this.cosmosAuthCredentials;
                AzureImdsCredentials cacheKeyImdsCreds = (AzureImdsCredentials)cacheKey.cosmosAuthCredentials;
                return Objects.equals(imdsCredentials.getSubscriptionId(), cacheKeyImdsCreds.getSubscriptionId());
            }
            if (this.cosmosAuthCredentials instanceof AzureCredentials) {
                AzureCredentials azureCredentials = (AzureCredentials)this.cosmosAuthCredentials;
                AzureCredentials cacheKeyAzureCredentials = (AzureCredentials)cacheKey.cosmosAuthCredentials;
                return Objects.equals(azureCredentials.getSubscriptionId(), cacheKeyAzureCredentials.getSubscriptionId()) && Objects.equals(azureCredentials.getTenant(), cacheKeyAzureCredentials.getTenant()) && Objects.equals(azureCredentials.getClientId(), cacheKeyAzureCredentials.getClientId()) && Objects.equals(azureCredentials.getPlainClientSecret(), cacheKeyAzureCredentials.getPlainClientSecret());
            }
            if (this.cosmosAuthCredentials instanceof AzureCosmosDBKeyCredentials) {
                AzureCosmosDBKeyCredentials keyCredentials = (AzureCosmosDBKeyCredentials)this.cosmosAuthCredentials;
                AzureCosmosDBKeyCredentials cacheKeyCredentials = (AzureCosmosDBKeyCredentials)cacheKey.cosmosAuthCredentials;
                return Objects.equals(keyCredentials.getKey(), cacheKeyCredentials.getKey());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.cosmosAuthCredentials, this.url, this.preferredRegion);
        }

        public String toString() {
            return String.format("CacheKey{cosmosAuthCredentials=%s, url='%s', preferredRegion='%s'}", this.cosmosAuthCredentials.getId(), this.url, this.preferredRegion);
        }
    }
}

