/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.azurecosmosdb;

import com.azure.cosmos.CosmosClient;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.microsoft.azure.util.AzureBaseCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.azurecosmosdb.AzureCosmosDBCredentials;
import io.jenkins.plugins.azurecosmosdb.AzureCosmosDBKeyCredentials;
import io.jenkins.plugins.azurecosmosdb.CredentialsHelper;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AzureCosmosDBCredentialsImpl
extends BaseStandardCredentials
implements AzureCosmosDBCredentials {
    private final String credentialsId;
    private final String preferredRegion;
    private final String url;

    @DataBoundConstructor
    public AzureCosmosDBCredentialsImpl(@CheckForNull CredentialsScope scope, String id, String description, String credentialsId, String preferredRegion, String url) {
        super(scope, id, description);
        this.credentialsId = credentialsId;
        this.preferredRegion = preferredRegion;
        this.url = url;
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public String getPreferredRegion() {
        return this.preferredRegion;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Azure Cosmos DB";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.either((CredentialsMatcher)CredentialsMatchers.instanceOf(AzureCosmosDBKeyCredentials.class), (CredentialsMatcher)CredentialsMatchers.instanceOf(AzureBaseCredentials.class))).includeCurrentValue(credentialsId);
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter String credentialsId, @QueryParameter String preferredRegion, @QueryParameter String url, @AncestorInPath Item item) {
            FormValidation formValidation;
            block11: {
                if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                    return FormValidation.ok();
                }
                if (StringUtils.isBlank((String)credentialsId)) {
                    return FormValidation.ok();
                }
                StandardCredentials credentials = CredentialsHelper.findCredentials(credentialsId, item);
                if (credentials == null) {
                    return FormValidation.error((String)"Cannot find currently selected credentials");
                }
                CosmosClient client = CredentialsHelper.createClient(credentials, preferredRegion, url);
                try {
                    formValidation = FormValidation.ok((String)("Found " + client.readAllDatabases().stream().count() + " database(s)."));
                    if (client == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        return FormValidation.error((Throwable)e, (String)("Failed to validate credentials: " + e.getMessage()));
                    }
                }
                client.close();
            }
            return formValidation;
        }
    }
}

