/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.azurecosmosdb;

import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosDatabase;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.azurecosmosdb.AzureCosmosDBCache;
import io.jenkins.plugins.azurecosmosdb.AzureCosmosDBCredentials;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AzureCosmosDBCreateDocumentStep
extends Step {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String credentialsId;
    private final String database;
    private final String container;
    private final Object document;

    @DataBoundConstructor
    public AzureCosmosDBCreateDocumentStep(String credentialsId, String database, String container, Object document) {
        String doc;
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        this.database = Util.fixEmpty((String)database);
        this.container = Util.fixEmpty((String)container);
        Object tmpDocument = document;
        if (document instanceof String && "".equals(doc = (String)tmpDocument)) {
            tmpDocument = null;
        }
        this.document = tmpDocument;
    }

    public StepExecution start(StepContext context) throws Exception {
        Run run = (Run)context.get(Run.class);
        Objects.requireNonNull(run, "Run must not be null");
        Job item = run.getParent();
        CosmosClient cosmosClient = AzureCosmosDBCache.get(this.credentialsId, (Item)item);
        return new Execution(context, cosmosClient, this.database, this.container, this.document);
    }

    public Object getDocument() {
        return this.document;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getContainer() {
        return this.container;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Not used in XStream")
    private static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private final transient CosmosClient client;
        private final String database;
        private final String container;
        private final Object document;

        protected Execution(@NonNull StepContext context, CosmosClient client, String database, String container, Object document) {
            super(context);
            this.client = client;
            this.database = database;
            this.container = container;
            this.document = document;
        }

        protected Void run() throws Exception {
            Objects.requireNonNull(this.database, "Database must be set");
            Objects.requireNonNull(this.container, "Container must be set");
            Objects.requireNonNull(this.document, "Document must be set");
            CosmosDatabase cosmosDatabase = this.client.getDatabase(this.database);
            CosmosContainer cosmosContainer = cosmosDatabase.getContainer(this.container);
            Object tmpDocument = this.document;
            if (this.document instanceof String) {
                ObjectNode node = (ObjectNode)OBJECT_MAPPER.readTree((String)this.document);
                tmpDocument = OBJECT_MAPPER.treeToValue((TreeNode)node, Object.class);
            }
            cosmosContainer.createItem(tmpDocument);
            TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
            if (taskListener != null) {
                taskListener.getLogger().printf("Created document in database: %s, container: %s%n", this.database, this.container);
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            HashSet<Class<TaskListener>> context = new HashSet<Class<TaskListener>>();
            context.add(TaskListener.class);
            return Collections.unmodifiableSet(context);
        }

        public String getFunctionName() {
            return "azureCosmosDBCreateDocument";
        }

        @NonNull
        public String getDisplayName() {
            return "Create document in Azure Cosmos DB";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, AzureCosmosDBCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(AzureCosmosDBCredentials.class)).includeCurrentValue(credentialsId);
        }
    }
}

