/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.azurecosmosdb;

import com.azure.core.credential.TokenCredential;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentials;
import hudson.model.Item;
import hudson.security.ACL;
import io.jenkins.plugins.azurecosmosdb.AzureCosmosDBKeyCredentials;
import java.util.Collections;
import org.acegisecurity.Authentication;

public class CredentialsHelper {
    private CredentialsHelper() {
    }

    public static StandardCredentials findCredentials(String credentialsId, Item context) {
        return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public static CosmosClient createClient(StandardCredentials standardCredentials, String preferredRegion, String url) {
        CosmosClientBuilder builder = new CosmosClientBuilder().endpoint(url).preferredRegions(Collections.singletonList(preferredRegion)).consistencyLevel(ConsistencyLevel.EVENTUAL).gatewayMode();
        if (standardCredentials instanceof AzureCosmosDBKeyCredentials) {
            builder = builder.key(((AzureCosmosDBKeyCredentials)standardCredentials).getKey().getPlainText());
        } else if (standardCredentials instanceof AzureBaseCredentials) {
            TokenCredential tokenCredential = AzureCredentials.getTokenCredential((AzureBaseCredentials)((AzureBaseCredentials)standardCredentials));
            builder = builder.credential(tokenCredential);
        } else {
            throw new RuntimeException("Unexpected credentials type: " + standardCredentials.getClass().getSimpleName().replace("Impl", ""));
        }
        return builder.buildClient();
    }
}

