/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.secretsmanager;

import hudson.Extension;
import io.jenkins.plugins.casc.SecretSource;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

@Extension
public class AwsSecretsManagerSecretSource
extends SecretSource {
    private static final Logger LOG = Logger.getLogger(AwsSecretsManagerSecretSource.class.getName());
    @Deprecated
    private static final String AWS_SERVICE_ENDPOINT = "AWS_SERVICE_ENDPOINT";
    private transient SecretsManagerClient client = null;

    public Optional<String> reveal(String id) throws IOException {
        try {
            GetSecretValueRequest request = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(id).build();
            GetSecretValueResponse result = this.client.getSecretValue(request);
            if (result.secretBinary() != null) {
                throw new IOException(String.format("The binary secret '%s' is not supported. Please change its value to a string, or alternatively delete it.", result.name()));
            }
            return Optional.ofNullable(result.secretString());
        }
        catch (ResourceNotFoundException e) {
            LOG.info(e.getMessage());
            return Optional.empty();
        }
        catch (SecretsManagerException e) {
            LOG.warning(e.getMessage());
            throw new IOException(e);
        }
    }

    public void init() {
        try {
            this.client = AwsSecretsManagerSecretSource.createClient();
        }
        catch (SdkClientException e) {
            LOG.log(Level.WARNING, "Could not set up AWS Secrets Manager client. Reason: {0}", e.getMessage());
        }
    }

    private static SecretsManagerClient createClient() throws SdkClientException {
        SecretsManagerClientBuilder builder = SecretsManagerClient.builder();
        Optional<String> maybeServiceEndpoint = AwsSecretsManagerSecretSource.getServiceEndpoint();
        if (maybeServiceEndpoint.isPresent()) {
            String serviceEndpoint = maybeServiceEndpoint.get();
            LOG.log(Level.CONFIG, "Custom Service Endpoint: {0}", serviceEndpoint);
            builder.endpointOverride(URI.create(serviceEndpoint));
        }
        return (SecretsManagerClient)builder.build();
    }

    private static Optional<String> getServiceEndpoint() {
        return Optional.ofNullable(System.getenv(AWS_SERVICE_ENDPOINT));
    }
}

