/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config.transformer.name.removePrefixes;

import hudson.Extension;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import io.jenkins.plugins.credentials.secretsmanager.config.transformer.name.NameTransformer;
import io.jenkins.plugins.credentials.secretsmanager.config.transformer.name.PrefixRemover;
import io.jenkins.plugins.credentials.secretsmanager.config.transformer.name.removePrefixes.Prefix;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RemovePrefixes
extends NameTransformer {
    private Set<Prefix> prefixes;

    @DataBoundConstructor
    public RemovePrefixes(Set<Prefix> prefixes) {
        this.prefixes = prefixes;
    }

    public Set<Prefix> getPrefixes() {
        return this.prefixes;
    }

    @DataBoundSetter
    public void setPrefixes(Set<Prefix> prefixes) {
        this.prefixes = prefixes;
    }

    @Override
    public String transform(String str) {
        Set<String> p = this.prefixes.stream().map(Prefix::getValue).collect(Collectors.toSet());
        return PrefixRemover.removePrefixes(p).from(str);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovePrefixes that = (RemovePrefixes)o;
        return Objects.equals(this.prefixes, that.prefixes);
    }

    public int hashCode() {
        return Objects.hash(this.prefixes);
    }

    @Extension
    @Symbol(value={"removePrefixes"})
    public static class DescriptorImpl
    extends NameTransformer.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return Messages.removePrefixes();
        }
    }
}

